/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class B2FlushAndSyncFileOnCloseOutputStream
extends OutputStream {
    private final FileOutputStream out;

    private B2FlushAndSyncFileOnCloseOutputStream(FileOutputStream out) {
        this.out = out;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        this.out.getFD().sync();
        this.out.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public static B2FlushAndSyncFileOnCloseOutputStream create(FileOutputStream out) {
        return new B2FlushAndSyncFileOnCloseOutputStream(out);
    }

    public static B2FlushAndSyncFileOnCloseOutputStream create(File outputFile) throws FileNotFoundException {
        return B2FlushAndSyncFileOnCloseOutputStream.create(new FileOutputStream(outputFile));
    }
}

