/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.VersionRange;
import java.lang.reflect.Field;

public final class FieldInfo
implements Comparable<FieldInfo> {
    public final Field field;
    public final B2JsonTypeHandler handler;
    public final FieldRequirement requirement;
    public final String defaultValueJsonOrNull;
    public final VersionRange versionRange;
    public int constructorArgIndex;
    public final boolean isSensitive;
    public final boolean omitNull;

    FieldInfo(Field field, B2JsonTypeHandler<?> handler, FieldRequirement requirement, String defaultValueJsonOrNull, VersionRange versionRange2, boolean isSensitive, boolean omitNull) {
        this.field = field;
        this.handler = handler;
        this.requirement = requirement;
        this.defaultValueJsonOrNull = defaultValueJsonOrNull;
        this.versionRange = versionRange2;
        this.isSensitive = isSensitive;
        this.omitNull = omitNull;
        this.field.setAccessible(true);
    }

    public String getName() {
        return this.field.getName();
    }

    public B2JsonTypeHandler getHandler() {
        return this.handler;
    }

    public boolean getIsSensitive() {
        return this.isSensitive;
    }

    @Override
    public int compareTo(FieldInfo o) {
        return this.field.getName().compareTo(o.field.getName());
    }

    public void setConstructorArgIndex(int index) {
        this.constructorArgIndex = index;
    }

    public boolean isInVersion(int version) {
        return this.versionRange.includesVersion(version);
    }

    public boolean isRequiredAndInVersion(int version) {
        return this.requirement == FieldRequirement.REQUIRED && this.versionRange.includesVersion(version);
    }

    public static enum FieldRequirement {
        REQUIRED,
        OPTIONAL,
        IGNORED;

    }
}

