/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonWriter;
import com.backblaze.b2.util.B2DateTimeUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.LocalDateTime;

public class B2JsonLocalDateTimeHandler
implements B2JsonTypeHandler<LocalDateTime> {
    @Override
    public Type getHandledType() {
        return LocalDateTime.class;
    }

    @Override
    public void serialize(LocalDateTime obj, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        out.writeString(B2DateTimeUtil.formatFguidDateTime(obj));
    }

    @Override
    public LocalDateTime deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        String str = in.readString();
        return B2DateTimeUtil.parseDateTime(str);
    }

    @Override
    public LocalDateTime deserializeUrlParam(String urlValue) throws B2JsonException {
        return B2DateTimeUtil.parseDateTime(urlValue);
    }

    @Override
    public LocalDateTime defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return true;
    }
}

