/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonNonUrlTypeHandler;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonUtil;
import com.backblaze.b2.json.B2JsonWriter;
import com.backblaze.b2.json.B2TypeResolver;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class B2JsonListHandler
extends B2JsonNonUrlTypeHandler<List> {
    private static final Set<Class<?>> PRIMITIVE_TYPES = new HashSet();
    private final B2JsonTypeHandler itemHandler;

    public B2JsonListHandler(B2JsonTypeHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public Type getHandledType() {
        return new B2TypeResolver.ResolvedParameterizedType((Type)((Object)List.class), new Type[]{this.itemHandler.getHandledType()});
    }

    @Override
    public void serialize(List obj, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        if (obj.size() != 0 && PRIMITIVE_TYPES.contains(obj.get(0).getClass())) {
            out.setAllowNewlines(false);
        }
        out.startArray();
        for (Object item : obj) {
            out.startArrayValue();
            B2JsonUtil.serializeMaybeNull(this.itemHandler, item, out, options);
        }
        out.finishArray();
        out.setAllowNewlines(true);
    }

    @Override
    public List deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        ArrayList result = new ArrayList();
        if (in.startArrayAndCheckForContents()) {
            do {
                result.add(B2JsonUtil.deserializeMaybeNull(this.itemHandler, in, options));
            } while (in.arrayHasMoreValues());
        }
        in.finishArray();
        return result;
    }

    @Override
    public List defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }

    static {
        PRIMITIVE_TYPES.add(Boolean.class);
        PRIMITIVE_TYPES.add(Byte.class);
        PRIMITIVE_TYPES.add(Character.class);
        PRIMITIVE_TYPES.add(Double.class);
        PRIMITIVE_TYPES.add(Float.class);
        PRIMITIVE_TYPES.add(Integer.class);
        PRIMITIVE_TYPES.add(Long.class);
    }
}

