/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonBadValueException;
import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonNonUrlTypeHandler;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonUtil;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class B2JsonIntArrayHandler
extends B2JsonNonUrlTypeHandler<int[]> {
    private final B2JsonTypeHandler itemHandler;

    public B2JsonIntArrayHandler(B2JsonTypeHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public Type getHandledType() {
        return int[].class;
    }

    @Override
    public void serialize(int[] array, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        out.setAllowNewlines(false);
        out.startArray();
        for (int item : array) {
            out.startArrayValue();
            B2JsonUtil.serializeMaybeNull(this.itemHandler, item, out, options);
        }
        out.finishArray();
        out.setAllowNewlines(true);
    }

    @Override
    public int[] deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (in.startArrayAndCheckForContents()) {
            do {
                result.add((Integer)B2JsonUtil.deserializeMaybeNull(this.itemHandler, in, options));
            } while (in.arrayHasMoreValues());
        }
        in.finishArray();
        int nElts = result.size();
        int[] array = new int[nElts];
        int i = 0;
        for (Integer elt : result) {
            if (elt == null) {
                throw new B2JsonBadValueException("can't put null in a int[].");
            }
            array[i] = elt;
            ++i;
        }
        return array;
    }

    @Override
    public int[] defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

