/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonWriter;
import com.backblaze.b2.util.B2DateTimeUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Duration;

class B2JsonDurationHandler
implements B2JsonTypeHandler<Duration> {
    B2JsonDurationHandler() {
    }

    @Override
    public Type getHandledType() {
        return Duration.class;
    }

    @Override
    public void serialize(Duration obj, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        out.writeString(B2DateTimeUtil.durationString(obj.getSeconds()));
    }

    @Override
    public Duration deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        String str = in.readString();
        return this.deserializeUrlParam(str);
    }

    @Override
    public Duration deserializeUrlParam(String urlValue) throws B2JsonException {
        return B2DateTimeUtil.parseDuration(urlValue);
    }

    @Override
    public Duration defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return true;
    }
}

