/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;

public class B2JsonCharacterHandler
implements B2JsonTypeHandler<Character> {
    private final boolean isPrimitive;

    public B2JsonCharacterHandler(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Type getHandledType() {
        return Character.class;
    }

    @Override
    public void serialize(Character obj, B2JsonOptions options, B2JsonWriter out) throws IOException {
        out.writeText(Integer.toString(obj.charValue()));
    }

    @Override
    public Character deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        String str = in.readNumberAsString();
        try {
            int value = Integer.valueOf(str);
            if (value < 0 || 65535 < value) {
                throw new B2JsonException("char value out of range: " + str);
            }
            return Character.valueOf((char)value);
        }
        catch (NumberFormatException e) {
            throw new B2JsonException("bad character: " + str);
        }
    }

    @Override
    public Character deserializeUrlParam(String urlValue) throws B2JsonException {
        try {
            int value = Integer.valueOf(urlValue);
            if (value < 0 || 65535 < value) {
                throw new B2JsonException("char value out of range: " + urlValue);
            }
            return Character.valueOf((char)value);
        }
        catch (NumberFormatException e) {
            throw new B2JsonException("bad character: " + urlValue);
        }
    }

    @Override
    public Character defaultValueForOptional() {
        if (this.isPrimitive) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

