/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonBadValueException;
import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonNonUrlTypeHandler;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonUtil;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class B2JsonCharArrayHandler
extends B2JsonNonUrlTypeHandler<char[]> {
    private final B2JsonTypeHandler itemHandler;

    public B2JsonCharArrayHandler(B2JsonTypeHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public Type getHandledType() {
        return char[].class;
    }

    @Override
    public void serialize(char[] array, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        out.setAllowNewlines(false);
        out.startArray();
        for (char item : array) {
            out.startArrayValue();
            B2JsonUtil.serializeMaybeNull(this.itemHandler, Character.valueOf(item), out, options);
        }
        out.finishArray();
        out.setAllowNewlines(true);
    }

    @Override
    public char[] deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        ArrayList<Character> result = new ArrayList<Character>();
        if (in.startArrayAndCheckForContents()) {
            do {
                result.add((Character)B2JsonUtil.deserializeMaybeNull(this.itemHandler, in, options));
            } while (in.arrayHasMoreValues());
        }
        in.finishArray();
        int nElts = result.size();
        char[] array = new char[nElts];
        int i = 0;
        for (Character elt : result) {
            if (elt == null) {
                throw new B2JsonBadValueException("can't put null in a char[].");
            }
            array[i] = elt.charValue();
            ++i;
        }
        return array;
    }

    @Override
    public char[] defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

