/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;

public class B2JsonByteHandler
implements B2JsonTypeHandler<Byte> {
    private final boolean isPrimitive;

    public B2JsonByteHandler(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Type getHandledType() {
        return Byte.class;
    }

    @Override
    public void serialize(Byte obj, B2JsonOptions options, B2JsonWriter out) throws IOException {
        out.writeText(obj.toString());
    }

    @Override
    public Byte deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        String str = in.readNumberAsString();
        try {
            return Byte.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new B2JsonException("bad byte: " + str);
        }
    }

    @Override
    public Byte deserializeUrlParam(String urlValue) throws B2JsonException {
        try {
            return Byte.valueOf(urlValue);
        }
        catch (NumberFormatException e) {
            throw new B2JsonException("bad byte: " + urlValue);
        }
    }

    @Override
    public Byte defaultValueForOptional() {
        if (this.isPrimitive) {
            return (byte)0;
        }
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

