/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.util.B2Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class B2JsonBoundedByteArrayOutputStream
extends OutputStream {
    public static final int SYSTEM_MAX_CAPACITY = 0x7FFFFFF7;
    private byte[] output;
    private int size;
    private final int maxCapacity;

    public B2JsonBoundedByteArrayOutputStream(int maxCapacity) {
        B2Preconditions.checkArgument(maxCapacity >= 0, "maxCapacity must not be negative.");
        B2Preconditions.checkArgument(maxCapacity <= 0x7FFFFFF7, "maxCapacity must not be bigger than 2147483639");
        this.maxCapacity = maxCapacity;
        this.size = 0;
        int initialCapacity = Math.min(64, maxCapacity);
        this.output = new byte[initialCapacity];
    }

    @Override
    public synchronized void write(int i) throws IOException {
        this.checkCapacity(1);
        this.output[this.size] = (byte)i;
        ++this.size;
    }

    @Override
    public synchronized void write(byte[] bytes, int offset, int length) throws IOException {
        this.validateParameters(bytes, offset, length);
        this.checkCapacity(length);
        System.arraycopy(bytes, offset, this.output, this.size, length);
        this.size += length;
    }

    public synchronized String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.output, 0, this.size, charsetName);
    }

    public synchronized byte[] toByteArray() {
        return Arrays.copyOf(this.output, this.size);
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public int getSize() {
        return this.size;
    }

    private void checkCapacity(int additionalCapacityNeeded) throws IOException {
        boolean willOverflow;
        boolean bl = willOverflow = this.maxCapacity - this.size < additionalCapacityNeeded;
        if (willOverflow) {
            throw new IOException("Requested array size exceeds maximum limit");
        }
        int leastRequiredCapacity = this.size + additionalCapacityNeeded;
        if (leastRequiredCapacity > this.output.length) {
            int newCapacity = this.expandCapacity(leastRequiredCapacity);
            this.output = Arrays.copyOf(this.output, newCapacity);
        }
    }

    private int expandCapacity(int leastCapacityRequired) {
        int newCapacity = this.output.length * 2;
        newCapacity = Math.max(newCapacity, leastCapacityRequired);
        newCapacity = Math.min(newCapacity, this.maxCapacity);
        return newCapacity;
    }

    private void validateParameters(byte[] bytes, int offset, int len) {
        if (offset < 0 || offset > bytes.length || len < 0 || offset + len - bytes.length > 0) {
            throw new IndexOutOfBoundsException(String.format("offset: %d, len: %d", offset, len));
        }
    }
}

