/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.structures.B2FileSseForRequest;
import com.backblaze.b2.util.B2Preconditions;
import java.util.Objects;

public class B2UploadPartRequest {
    private final int partNumber;
    private final B2ContentSource contentSource;
    private final B2FileSseForRequest serverSideEncryption;

    private B2UploadPartRequest(int partNumber, B2ContentSource contentSource, B2FileSseForRequest serverSideEncryption) {
        B2Preconditions.checkArgument(serverSideEncryption == null || "SSE-C".equals(serverSideEncryption.getMode()));
        this.partNumber = partNumber;
        this.contentSource = contentSource;
        this.serverSideEncryption = serverSideEncryption;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public B2ContentSource getContentSource() {
        return this.contentSource;
    }

    public B2FileSseForRequest getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2UploadPartRequest that = (B2UploadPartRequest)o;
        return this.getPartNumber() == that.getPartNumber() && Objects.equals(this.getContentSource(), that.getContentSource()) && Objects.equals(this.getServerSideEncryption(), that.getServerSideEncryption());
    }

    public int hashCode() {
        return Objects.hash(this.getPartNumber(), this.getContentSource(), this.getServerSideEncryption());
    }

    public static Builder builder(int partNumber, B2ContentSource source) {
        return new Builder(partNumber, source);
    }

    public static class Builder {
        private final int partNumber;
        private final B2ContentSource source;
        private B2FileSseForRequest serverSideEncryption;

        Builder(int partNumber, B2ContentSource source) {
            this.partNumber = partNumber;
            this.source = source;
        }

        public Builder setServerSideEncryption(B2FileSseForRequest serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public B2UploadPartRequest build() {
            return new B2UploadPartRequest(this.partNumber, this.source, this.serverSideEncryption);
        }
    }
}

