/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.exceptions.B2ForbiddenException;
import com.backblaze.b2.client.structures.B2AuthorizationFilteredResponseField;
import com.backblaze.b2.client.structures.B2FileRetention;
import com.backblaze.b2.client.structures.B2FileSseForResponse;
import com.backblaze.b2.json.B2Json;
import java.util.Map;
import java.util.Objects;

public class B2FileVersion {
    public static final String UPLOAD_ACTION = "upload";
    public static final String HIDE_ACTION = "hide";
    public static final String START_ACTION = "start";
    public static final String FOLDER_ACTION = "folder";
    @B2Json.optional
    private final String fileId;
    @B2Json.required
    private final String fileName;
    @B2Json.optional
    private final long contentLength;
    @B2Json.optional
    private final String contentType;
    @B2Json.optional
    private final String contentSha1;
    @B2Json.optional
    private final String contentMd5;
    @B2Json.optional
    private final Map<String, String> fileInfo;
    @B2Json.optional
    private final String action;
    @B2Json.required
    private final long uploadTimestamp;
    @B2Json.optional
    private final B2AuthorizationFilteredResponseField<B2FileRetention> fileRetention;
    @B2Json.optional
    private final B2AuthorizationFilteredResponseField<String> legalHold;
    @B2Json.optional
    private final B2FileSseForResponse serverSideEncryption;
    @B2Json.optional
    private final String replicationStatus;

    @B2Json.constructor(params="fileId,fileName,contentLength,contentType,contentSha1,contentMd5,fileInfo,action,uploadTimestamp,fileRetention,legalHold,serverSideEncryption,replicationStatus")
    public B2FileVersion(String fileId, String fileName, long contentLength, String contentType, String contentSha1, String contentMd5, Map<String, String> fileInfo, String action, long uploadTimestamp, B2AuthorizationFilteredResponseField<B2FileRetention> fileRetention, B2AuthorizationFilteredResponseField<String> legalHold, B2FileSseForResponse serverSideEncryption, String replicationStatus) {
        this.fileId = fileId;
        this.fileName = fileName;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.contentSha1 = contentSha1;
        this.contentMd5 = contentMd5;
        this.fileInfo = fileInfo;
        this.action = action;
        this.uploadTimestamp = uploadTimestamp;
        this.fileRetention = fileRetention;
        this.legalHold = legalHold;
        this.serverSideEncryption = serverSideEncryption;
        this.replicationStatus = replicationStatus;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentSha1() {
        return this.contentSha1;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public String getLargeFileSha1OrNull() {
        return this.fileInfo.get("large_file_sha1");
    }

    public Map<String, String> getFileInfo() {
        return this.fileInfo;
    }

    public String getAction() {
        return this.action;
    }

    public long getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    public boolean isClientAuthorizedToReadFileRetention() {
        if (this.fileRetention == null) {
            return true;
        }
        return this.fileRetention.isClientAuthorizedToRead();
    }

    public B2FileRetention getFileRetention() throws B2ForbiddenException {
        return this.fileRetention == null ? null : this.fileRetention.getValue();
    }

    public boolean isClientAuthorizedToReadLegalHold() {
        if (this.legalHold == null) {
            return true;
        }
        return this.legalHold.isClientAuthorizedToRead();
    }

    public String getLegalHold() throws B2ForbiddenException {
        return this.legalHold == null ? null : this.legalHold.getValue();
    }

    public B2FileSseForResponse getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public String getReplicationStatus() {
        return this.replicationStatus;
    }

    public boolean isUpload() {
        return UPLOAD_ACTION.equals(this.action);
    }

    public boolean isHide() {
        return HIDE_ACTION.equals(this.action);
    }

    public boolean isStart() {
        return START_ACTION.equals(this.action);
    }

    public boolean isFolder() {
        return FOLDER_ACTION.equals(this.action);
    }

    public String toString() {
        return "B2FileVersion{fileId='" + this.fileId + "', contentLength=" + this.contentLength + ", contentType='" + this.contentType + "', contentSha1='" + this.contentSha1 + "', contentMd5='" + this.contentMd5 + "', action='" + this.action + "', uploadTimestamp=" + this.uploadTimestamp + ", fileInfo=[" + (this.fileInfo != null ? Integer.valueOf(this.fileInfo.size()) : "") + "], fileName='" + this.fileName + "', fileRetention='" + this.fileRetention + "', legalHold='" + this.legalHold + "', serverSideEncryption='" + this.serverSideEncryption + "', replicationStatus='" + this.replicationStatus + "'" + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2FileVersion that = (B2FileVersion)o;
        return this.getContentLength() == that.getContentLength() && this.getUploadTimestamp() == that.getUploadTimestamp() && Objects.equals(this.getFileId(), that.getFileId()) && Objects.equals(this.getFileName(), that.getFileName()) && Objects.equals(this.getContentType(), that.getContentType()) && Objects.equals(this.getContentSha1(), that.getContentSha1()) && Objects.equals(this.getContentMd5(), that.getContentMd5()) && Objects.equals(this.getFileInfo(), that.getFileInfo()) && Objects.equals(this.getAction(), that.getAction()) && Objects.equals(this.fileRetention, that.fileRetention) && Objects.equals(this.legalHold, that.legalHold) && Objects.equals(this.getServerSideEncryption(), that.getServerSideEncryption()) && Objects.equals(this.getReplicationStatus(), that.getReplicationStatus());
    }

    public int hashCode() {
        return Objects.hash(this.getFileId(), this.getFileName(), this.getContentLength(), this.getContentType(), this.getContentSha1(), this.getContentMd5(), this.getFileInfo(), this.getAction(), this.getUploadTimestamp(), this.fileRetention, this.legalHold, this.getServerSideEncryption(), this.getReplicationStatus());
    }
}

