/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.contentSources.B2Headers;
import com.backblaze.b2.json.B2Json;
import java.util.Objects;

public class B2FileSseForResponse {
    @B2Json.optional
    private final String mode;
    @B2Json.optional
    private final String algorithm;
    @B2Json.optional(omitNull=true)
    private final String customerKeyMd5;

    @B2Json.constructor(params="mode, algorithm, customerKeyMd5")
    public B2FileSseForResponse(String mode, String algorithm, String customerKeyMd5) {
        this.mode = mode;
        this.algorithm = algorithm;
        this.customerKeyMd5 = customerKeyMd5;
    }

    public String getMode() {
        return this.mode;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getCustomerKeyMd5() {
        return this.customerKeyMd5;
    }

    public static B2FileSseForResponse getEncryptionFromHeadersOrNull(B2Headers headers) {
        if (headers == null) {
            return null;
        }
        String algorithm = headers.getServerSideEncryptionOrNull();
        if (algorithm != null) {
            return new B2FileSseForResponse("SSE-B2", algorithm, null);
        }
        String customerAlgorithm = headers.getSseCustomerAlgorithmOrNull();
        if (customerAlgorithm != null) {
            return new B2FileSseForResponse("SSE-C", customerAlgorithm, headers.getSseCustomerKeyMd5OrNull());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2FileSseForResponse that = (B2FileSseForResponse)o;
        return Objects.equals(this.mode, that.getMode()) && Objects.equals(this.algorithm, that.getAlgorithm()) && Objects.equals(this.customerKeyMd5, that.getCustomerKeyMd5());
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.algorithm, this.customerKeyMd5);
    }

    public String toString() {
        return "B2FileSseForResponse{mode='" + this.mode + "', algorithm=" + this.algorithm + ", customerKeyMd5=" + this.customerKeyMd5 + "}";
    }
}

