/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.util.B2Md5;
import com.backblaze.b2.util.B2Preconditions;
import java.util.Base64;
import java.util.Objects;

public class B2FileSseForRequest {
    @B2Json.required
    private final String mode;
    @B2Json.required
    private final String algorithm;
    @B2Json.optional(omitNull=true)
    private final String customerKey;
    @B2Json.optional(omitNull=true)
    private final String customerKeyMd5;
    private static final B2FileSseForRequest SSE_B2_AES256 = new B2FileSseForRequest("SSE-B2", "AES256", null, null);

    @B2Json.constructor(params="mode, algorithm, customerKey, customerKeyMd5")
    private B2FileSseForRequest(String mode, String algorithm, String customerKeyOrNull, String customerKeyMd5OrNull) {
        B2Preconditions.checkArgumentIsNotNull(mode, "mode");
        B2Preconditions.checkArgumentIsNotNull(algorithm, "algorithm");
        if (mode.equals("SSE-C")) {
            B2Preconditions.checkArgumentIsNotNull(customerKeyOrNull, "customerKeyOrNull");
            B2Preconditions.checkArgumentIsNotNull(customerKeyMd5OrNull, "customerKeyMd5OrNull");
        }
        this.mode = mode;
        this.algorithm = algorithm;
        this.customerKey = customerKeyOrNull;
        this.customerKeyMd5 = customerKeyMd5OrNull;
    }

    public static B2FileSseForRequest createSseB2Aes256() {
        return SSE_B2_AES256;
    }

    public static B2FileSseForRequest createSseCAes256(String customerKey) {
        byte[] customerKeyBytes = Base64.getDecoder().decode(customerKey);
        String customerKeyMd5 = Base64.getEncoder().encodeToString(B2Md5.binaryMd5OfBytes(customerKeyBytes));
        return new B2FileSseForRequest("SSE-C", "AES256", customerKey, customerKeyMd5);
    }

    public static B2FileSseForRequest createSseCAes256(String customerKey, String customerKeyMd5) {
        return new B2FileSseForRequest("SSE-C", "AES256", customerKey, customerKeyMd5);
    }

    public String getMode() {
        return this.mode;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getCustomerKey() {
        return this.customerKey;
    }

    public String getCustomerKeyMd5() {
        return this.customerKeyMd5;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2FileSseForRequest that = (B2FileSseForRequest)o;
        return Objects.equals(this.mode, that.getMode()) && Objects.equals(this.algorithm, that.getAlgorithm()) && Objects.equals(this.customerKey, that.getCustomerKey()) && Objects.equals(this.customerKeyMd5, that.getCustomerKeyMd5());
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.algorithm, this.customerKey, this.customerKeyMd5);
    }

    public String toString() {
        return "B2FileSseForRequest{mode='" + this.mode + "', algorithm=" + this.algorithm + ", customerKey=" + this.customerKey + ", customerKeyMd5=" + this.customerKeyMd5 + '}';
    }
}

