/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.contentSources.B2Headers;
import com.backblaze.b2.json.B2Json;
import java.util.Objects;

public class B2FileRetention {
    @B2Json.optional
    private final String mode;
    @B2Json.optional
    private final Long retainUntilTimestamp;
    public static final B2FileRetention NONE = new B2FileRetention(null, null);

    @B2Json.constructor(params="mode, retainUntilTimestamp")
    public B2FileRetention(String mode, Long retainUntilTimestamp) {
        this.mode = mode;
        this.retainUntilTimestamp = retainUntilTimestamp;
    }

    public static B2FileRetention getFileRetentionFromHeadersOrNull(B2Headers headers) {
        if (headers == null) {
            return null;
        }
        String mode = headers.getFileRetentionModeOrNull();
        Long retainUntilTimestamp = headers.getFileRetentionRetainUntilTimestampOrNull();
        if (mode == null || retainUntilTimestamp == null) {
            return null;
        }
        return new B2FileRetention(mode, retainUntilTimestamp);
    }

    public String getMode() {
        return this.mode;
    }

    public Long getRetainUntilTimestamp() {
        return this.retainUntilTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2FileRetention that = (B2FileRetention)o;
        return Objects.equals(this.mode, that.getMode()) && Objects.equals(this.retainUntilTimestamp, that.getRetainUntilTimestamp());
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.retainUntilTimestamp);
    }

    public String toString() {
        return "B2FileRetention{mode=" + this.mode + ", retainUntilTimestamp=" + this.retainUntilTimestamp + '}';
    }
}

