/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.structures.B2CreateKeyRequest;
import com.backblaze.b2.json.B2Json;
import java.util.Objects;
import java.util.Set;

public class B2CreateKeyRequestReal {
    @B2Json.required
    private final String accountId;
    @B2Json.required
    private final Set<String> capabilities;
    @B2Json.required
    private final String keyName;
    @B2Json.optional
    private final Long validDurationInSeconds;
    @B2Json.optional
    private final String bucketId;
    @B2Json.optional
    private final String namePrefix;

    @B2Json.constructor(params="accountId, capabilities, keyName, validDurationInSeconds, bucketId, namePrefix")
    private B2CreateKeyRequestReal(String accountId, Set<String> capabilities, String keyName, Long validDurationInSeconds, String bucketId, String namePrefix) {
        this.accountId = accountId;
        this.capabilities = capabilities;
        this.keyName = keyName;
        this.validDurationInSeconds = validDurationInSeconds;
        this.bucketId = bucketId;
        this.namePrefix = namePrefix;
    }

    public B2CreateKeyRequestReal(String accountId, B2CreateKeyRequest mostOfRequest) {
        this(accountId, mostOfRequest.getCapabilities(), mostOfRequest.getKeyName(), mostOfRequest.getValidDurationInSeconds(), mostOfRequest.getBucketId(), mostOfRequest.getNamePrefix());
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Long getValidDurationInSeconds() {
        return this.validDurationInSeconds;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2CreateKeyRequestReal that = (B2CreateKeyRequestReal)o;
        return Objects.equals(this.accountId, that.accountId) && Objects.equals(this.capabilities, that.capabilities) && Objects.equals(this.keyName, that.keyName) && Objects.equals(this.validDurationInSeconds, that.validDurationInSeconds) && Objects.equals(this.bucketId, that.bucketId) && Objects.equals(this.namePrefix, that.namePrefix);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.capabilities, this.keyName, this.validDurationInSeconds, this.bucketId, this.namePrefix);
    }
}

