/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import java.util.Objects;
import java.util.Set;

public class B2CreateKeyRequest {
    private final Set<String> capabilities;
    private final String keyName;
    private final Long validDurationInSeconds;
    private final String bucketId;
    private final String namePrefix;

    private B2CreateKeyRequest(Set<String> capabilities, String keyName, Long validDurationInSeconds, String bucketId, String namePrefix) {
        this.capabilities = capabilities;
        this.keyName = keyName;
        this.validDurationInSeconds = validDurationInSeconds;
        this.bucketId = bucketId;
        this.namePrefix = namePrefix;
    }

    public static Builder builder(Set<String> capabilities, String keyName) {
        return new Builder(capabilities, keyName);
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Long getValidDurationInSeconds() {
        return this.validDurationInSeconds;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2CreateKeyRequest that = (B2CreateKeyRequest)o;
        return Objects.equals(this.capabilities, that.capabilities) && Objects.equals(this.keyName, that.keyName) && Objects.equals(this.validDurationInSeconds, that.validDurationInSeconds) && Objects.equals(this.bucketId, that.bucketId) && Objects.equals(this.namePrefix, that.namePrefix);
    }

    public int hashCode() {
        return Objects.hash(this.capabilities, this.keyName, this.validDurationInSeconds, this.bucketId, this.namePrefix);
    }

    public static class Builder {
        private final Set<String> capabilities;
        private final String keyName;
        private Long validDurationInSeconds = null;
        private String bucketId = null;
        private String namePrefix = null;

        private Builder(Set<String> capabilities, String keyName) {
            this.capabilities = capabilities;
            this.keyName = keyName;
        }

        public Builder setValidDurationInSeconds(Long validDurationInSeconds) {
            this.validDurationInSeconds = validDurationInSeconds;
            return this;
        }

        public Builder setBucketId(String bucketId) {
            this.bucketId = bucketId;
            return this;
        }

        public Builder setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public B2CreateKeyRequest build() {
            return new B2CreateKeyRequest(this.capabilities, this.keyName, this.validDurationInSeconds, this.bucketId, this.namePrefix);
        }
    }
}

