/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.structures.B2FileSseForRequest;
import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.util.B2ByteRange;
import java.util.Objects;

public class B2CopyPartRequest {
    @B2Json.required
    private final int partNumber;
    @B2Json.required
    private final String sourceFileId;
    @B2Json.required
    private final String largeFileId;
    @B2Json.optional
    private final String range;
    @B2Json.optional
    private final B2FileSseForRequest sourceServerSideEncryption;
    @B2Json.optional
    private final B2FileSseForRequest destinationServerSideEncryption;

    @B2Json.constructor(params="partNumber, sourceFileId, largeFileId, range, sourceServerSideEncryption, destinationServerSideEncryption")
    private B2CopyPartRequest(int partNumber, String sourceFileId, String largeFileId, String range, B2FileSseForRequest sourceServerSideEncryption, B2FileSseForRequest destinationServerSideEncryption) {
        this.partNumber = partNumber;
        this.sourceFileId = sourceFileId;
        this.largeFileId = largeFileId;
        this.range = range;
        this.sourceServerSideEncryption = sourceServerSideEncryption;
        this.destinationServerSideEncryption = destinationServerSideEncryption;
    }

    public static Builder builder(int partNumber, String sourceFileId, String largeFileId) {
        return new Builder(partNumber, sourceFileId, largeFileId);
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public String getSourceFileId() {
        return this.sourceFileId;
    }

    public String getLargeFileId() {
        return this.largeFileId;
    }

    public String getRange() {
        return this.range;
    }

    public B2FileSseForRequest getSourceServerSideEncryption() {
        return this.sourceServerSideEncryption;
    }

    public B2FileSseForRequest getDestinationServerSideEncryption() {
        return this.destinationServerSideEncryption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2CopyPartRequest that = (B2CopyPartRequest)o;
        return this.partNumber == that.partNumber && Objects.equals(this.sourceFileId, that.sourceFileId) && Objects.equals(this.largeFileId, that.largeFileId) && Objects.equals(this.range, that.range) && Objects.equals(this.sourceServerSideEncryption, that.sourceServerSideEncryption) && Objects.equals(this.destinationServerSideEncryption, that.destinationServerSideEncryption);
    }

    public int hashCode() {
        return Objects.hash(this.partNumber, this.sourceFileId, this.largeFileId, this.range, this.sourceServerSideEncryption, this.destinationServerSideEncryption);
    }

    public static class Builder {
        private final int partNumber;
        private final String sourceFileId;
        private final String largeFileId;
        private B2ByteRange range;
        private B2FileSseForRequest sourceServerSideEncryption;
        private B2FileSseForRequest destinationServerSideEncryption;

        public Builder(int partNumber, String sourceFileId, String largeFileId) {
            this.partNumber = partNumber;
            this.sourceFileId = sourceFileId;
            this.largeFileId = largeFileId;
        }

        public Builder setRange(B2ByteRange range) {
            this.range = range;
            return this;
        }

        public Builder setSourceServerSideEncryption(B2FileSseForRequest sourceServerSideEncryption) {
            this.sourceServerSideEncryption = sourceServerSideEncryption;
            return this;
        }

        public Builder setDestinationServerSideEncryption(B2FileSseForRequest destinationServerSideEncryption) {
            this.destinationServerSideEncryption = destinationServerSideEncryption;
            return this;
        }

        public B2CopyPartRequest build() {
            return new B2CopyPartRequest(this.partNumber, this.sourceFileId, this.largeFileId, this.range == null ? null : this.range.toString(), this.sourceServerSideEncryption, this.destinationServerSideEncryption);
        }
    }
}

