/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.structures.B2ReplicationRule;
import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.util.B2Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class B2BucketReplicationConfiguration {
    @B2Json.optional
    private final B2SourceConfig asReplicationSource;
    @B2Json.optional
    private final B2DestinationConfig asReplicationDestination;
    public static final B2BucketReplicationConfiguration NONE = new B2BucketReplicationConfiguration(null, null);

    @B2Json.constructor(params="asReplicationSource, asReplicationDestination")
    private B2BucketReplicationConfiguration(B2SourceConfig asReplicationSource, B2DestinationConfig asReplicationDestination) {
        this.asReplicationSource = asReplicationSource;
        this.asReplicationDestination = asReplicationDestination;
    }

    public static B2BucketReplicationConfiguration createForSourceAndDestination(String sourceApplicationKeyId, List<B2ReplicationRule> replicationRules, Map<String, String> sourceToDestinationKeyMapping) {
        return new B2BucketReplicationConfiguration(new B2SourceConfig(sourceApplicationKeyId, replicationRules), new B2DestinationConfig(sourceToDestinationKeyMapping));
    }

    public static B2BucketReplicationConfiguration createForSource(String sourceApplicationKeyId, List<B2ReplicationRule> replicationRules) {
        return new B2BucketReplicationConfiguration(new B2SourceConfig(sourceApplicationKeyId, replicationRules), null);
    }

    public static B2BucketReplicationConfiguration createForDestination(Map<String, String> sourceToDestinationKeyMapping) {
        return new B2BucketReplicationConfiguration(null, new B2DestinationConfig(sourceToDestinationKeyMapping));
    }

    public String getSourceApplicationKeyIdOrNull() {
        return this.asReplicationSource == null ? null : this.asReplicationSource.sourceApplicationKeyId;
    }

    public List<B2ReplicationRule> getReplicationRulesOrNull() {
        return this.asReplicationSource == null ? null : this.asReplicationSource.replicationRules;
    }

    public Map<String, String> getSourceToDestinationKeyMappingOrNull() {
        return this.asReplicationDestination == null ? null : this.asReplicationDestination.sourceToDestinationKeyMapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2BucketReplicationConfiguration that = (B2BucketReplicationConfiguration)o;
        return Objects.equals(this.asReplicationSource, that.asReplicationSource) && Objects.equals(this.asReplicationDestination, that.asReplicationDestination);
    }

    public int hashCode() {
        return Objects.hash(this.asReplicationSource, this.asReplicationDestination);
    }

    public String toString() {
        return "B2BucketReplicationConfiguration{asReplicationSource=" + this.asReplicationSource + ", asReplicationDestination=" + this.asReplicationDestination + '}';
    }

    private static class B2DestinationConfig {
        @B2Json.required
        private final Map<String, String> sourceToDestinationKeyMapping;

        @B2Json.constructor(params="sourceToDestinationKeyMapping")
        private B2DestinationConfig(Map<String, String> sourceToDestinationKeyMapping) {
            B2Preconditions.checkArgumentIsNotNull(sourceToDestinationKeyMapping, "sourceToDestinationKeyMapping");
            B2Preconditions.checkArgument(!sourceToDestinationKeyMapping.isEmpty(), "sourceToDestinationKeyMapping is empty");
            this.sourceToDestinationKeyMapping = sourceToDestinationKeyMapping;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            B2DestinationConfig that = (B2DestinationConfig)o;
            return Objects.equals(this.sourceToDestinationKeyMapping, that.sourceToDestinationKeyMapping);
        }

        public int hashCode() {
            return Objects.hash(this.sourceToDestinationKeyMapping);
        }

        public String toString() {
            return "B2DestinationConfig{sourceToDestinationKeyMapping=" + this.sourceToDestinationKeyMapping + '}';
        }
    }

    private static class B2SourceConfig {
        @B2Json.required
        private final String sourceApplicationKeyId;
        @B2Json.required
        private final List<B2ReplicationRule> replicationRules;

        @B2Json.constructor(params="sourceApplicationKeyId, replicationRules")
        private B2SourceConfig(String sourceApplicationKeyId, List<B2ReplicationRule> replicationRules) {
            B2Preconditions.checkArgumentIsNotNull(replicationRules, "replicationRules");
            B2Preconditions.checkArgument(!replicationRules.isEmpty(), "replicationRules is empty");
            this.sourceApplicationKeyId = sourceApplicationKeyId;
            this.replicationRules = replicationRules;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            B2SourceConfig that = (B2SourceConfig)o;
            return Objects.equals(this.sourceApplicationKeyId, that.sourceApplicationKeyId) && Objects.equals(this.replicationRules, that.replicationRules);
        }

        public int hashCode() {
            return Objects.hash(this.sourceApplicationKeyId, this.replicationRules);
        }

        public String toString() {
            return "B2SourceConfig{sourceApplicationKeyId='" + this.sourceApplicationKeyId + '\'' + ", replicationRules=" + this.replicationRules + '}';
        }
    }
}

