/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.structures.B2BucketDefaultRetention;
import com.backblaze.b2.client.structures.B2BucketDefaultRetentionPeriod;
import com.backblaze.b2.json.B2Json;
import java.util.Objects;

public class B2BucketFileLockConfiguration {
    @B2Json.required
    private final boolean isFileLockEnabled;
    @B2Json.required
    private final B2BucketDefaultRetention defaultRetention;

    @B2Json.constructor(params="isFileLockEnabled, defaultRetention")
    public B2BucketFileLockConfiguration(boolean isFileLockEnabled, B2BucketDefaultRetention defaultRetention) {
        this.isFileLockEnabled = isFileLockEnabled;
        this.defaultRetention = defaultRetention;
    }

    public B2BucketFileLockConfiguration(boolean isFileLockEnabled, String mode, int duration, String unit) {
        this.isFileLockEnabled = isFileLockEnabled;
        this.defaultRetention = new B2BucketDefaultRetention(mode, new B2BucketDefaultRetentionPeriod(duration, unit));
    }

    public B2BucketFileLockConfiguration(boolean isFileLockEnabled) {
        this.isFileLockEnabled = isFileLockEnabled;
        this.defaultRetention = new B2BucketDefaultRetention(null, null);
    }

    public boolean isFileLockEnabled() {
        return this.isFileLockEnabled;
    }

    public B2BucketDefaultRetention getDefaultRetention() {
        return this.defaultRetention;
    }

    public String getDefaultRetentionMode() {
        if (this.defaultRetention == null) {
            return null;
        }
        return this.defaultRetention.getMode();
    }

    public B2BucketDefaultRetentionPeriod getDefaultRetentionPeriod() {
        if (this.defaultRetention == null) {
            return null;
        }
        return this.defaultRetention.getPeriod();
    }

    public String toString() {
        return this.isFileLockEnabled + "," + this.defaultRetention;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2BucketFileLockConfiguration that = (B2BucketFileLockConfiguration)o;
        return this.isFileLockEnabled == that.isFileLockEnabled && Objects.equals(this.defaultRetention, that.defaultRetention);
    }

    public int hashCode() {
        return Objects.hash(this.isFileLockEnabled, this.defaultRetention);
    }
}

