/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.exceptions.B2ForbiddenException;
import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.util.B2Preconditions;
import java.util.Objects;

public class B2AuthorizationFilteredResponseField<T> {
    @B2Json.required
    private final boolean isClientAuthorizedToRead;
    @B2Json.optional
    private final T value;

    @B2Json.constructor(params="isClientAuthorizedToRead, value")
    public B2AuthorizationFilteredResponseField(boolean isClientAuthorizedToRead, T value) {
        B2Preconditions.checkArgument(isClientAuthorizedToRead || value == null, "value must be null if isClientAuthorizedToRead is false");
        this.isClientAuthorizedToRead = isClientAuthorizedToRead;
        this.value = value;
    }

    T getValue() throws B2ForbiddenException {
        if (!this.isClientAuthorizedToRead()) {
            throw new B2ForbiddenException(null, null, "client is not authorized to read value");
        }
        return this.value;
    }

    boolean isClientAuthorizedToRead() {
        return this.isClientAuthorizedToRead;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2AuthorizationFilteredResponseField that = (B2AuthorizationFilteredResponseField)o;
        return this.isClientAuthorizedToRead == that.isClientAuthorizedToRead && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.isClientAuthorizedToRead, this.value);
    }

    public String toString() {
        return "B2AuthorizationFilteredResponseField(isClientAuthorizedToRead=" + this.isClientAuthorizedToRead + ",value={" + this.value + "})";
    }
}

