/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.exceptions;

import com.backblaze.b2.client.exceptions.B2BadRequestException;
import com.backblaze.b2.client.exceptions.B2ForbiddenException;
import com.backblaze.b2.client.exceptions.B2InternalErrorException;
import com.backblaze.b2.client.exceptions.B2NotFoundException;
import com.backblaze.b2.client.exceptions.B2RequestTimeoutException;
import com.backblaze.b2.client.exceptions.B2ServiceUnavailableException;
import com.backblaze.b2.client.exceptions.B2TooManyRequestsException;
import com.backblaze.b2.client.exceptions.B2UnauthorizedException;

public class B2Exception
extends Exception {
    public static final String DEFAULT_CODE = "unknown_code";
    private final String code;
    private final int status;
    private final Integer retryAfterSecondsOrNull;

    public B2Exception(String code, int status, Integer retryAfterSecondsOrNull, String message) {
        this(code, status, retryAfterSecondsOrNull, message, null);
    }

    public B2Exception(String code, int status, Integer retryAfterSecondsOrNull, String message, Throwable cause) {
        super(message, cause);
        this.code = B2Exception.orIfNull(code, DEFAULT_CODE);
        this.status = status;
        this.retryAfterSecondsOrNull = retryAfterSecondsOrNull;
    }

    @Override
    public String toString() {
        return "<B2Exception " + this.status + " " + this.code + ": " + this.getMessage() + ">";
    }

    public String getCode() {
        return this.code;
    }

    public int getStatus() {
        return this.status;
    }

    public Integer getRetryAfterSecondsOrNull() {
        return this.retryAfterSecondsOrNull;
    }

    public static B2Exception create(String code, int status, Integer retryAfterSecondsOrNull, String message) {
        switch (status) {
            case 404: {
                return new B2NotFoundException(code, retryAfterSecondsOrNull, message);
            }
            case 400: {
                return new B2BadRequestException(code, retryAfterSecondsOrNull, message);
            }
            case 401: {
                return new B2UnauthorizedException(code, retryAfterSecondsOrNull, message);
            }
            case 403: {
                return new B2ForbiddenException(code, retryAfterSecondsOrNull, message);
            }
            case 408: {
                return new B2RequestTimeoutException(code, retryAfterSecondsOrNull, message);
            }
            case 429: {
                return new B2TooManyRequestsException(code, retryAfterSecondsOrNull, message);
            }
            case 500: {
                return new B2InternalErrorException(code, retryAfterSecondsOrNull, message);
            }
            case 503: {
                return new B2ServiceUnavailableException(code, retryAfterSecondsOrNull, message);
            }
        }
        return new B2Exception(code, status, retryAfterSecondsOrNull, message);
    }

    static String orIfNull(String orig, String ifNull) {
        if (orig != null) {
            return orig;
        }
        return ifNull;
    }
}

