/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.credentialsSources;

import com.backblaze.b2.client.credentialsSources.B2Credentials;
import com.backblaze.b2.client.credentialsSources.B2CredentialsImpl;
import com.backblaze.b2.client.credentialsSources.B2CredentialsSource;
import com.backblaze.b2.util.B2Preconditions;

public class B2CredentialsFromEnvironmentSource
implements B2CredentialsSource {
    private final B2Credentials credentials;
    private String errorMessageOrNull;

    private B2CredentialsFromEnvironmentSource() {
        B2CredentialsImpl tmp;
        try {
            String applicationKeyId = this.getApplicationKeyIdOrThrow();
            String appKey = System.getenv("B2_APPLICATION_KEY");
            B2Preconditions.checkState(appKey != null, "B2_APPLICATION_KEY must be set in the environment");
            B2Preconditions.checkState(!appKey.isEmpty(), "B2_APPLICATION_KEY must be non-empty.");
            tmp = new B2CredentialsImpl(applicationKeyId, appKey);
        }
        catch (IllegalStateException e) {
            tmp = null;
            this.errorMessageOrNull = e.toString();
        }
        this.credentials = tmp;
    }

    @Override
    public B2Credentials getCredentials() {
        B2Preconditions.checkState(this.credentials != null, this.errorMessageOrNull);
        return this.credentials;
    }

    public static B2CredentialsSource build() {
        return new B2CredentialsFromEnvironmentSource();
    }

    public boolean canGetCredentials() {
        try {
            B2CredentialsFromEnvironmentSource.build().getCredentials();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private String getApplicationKeyIdOrThrow() throws IllegalArgumentException {
        String accountId;
        String applicationKeyId = System.getenv("B2_APPLICATION_KEY_ID");
        if (applicationKeyId == null && (accountId = System.getenv("B2_ACCOUNT_ID")) != null) {
            B2Preconditions.checkState(!accountId.isEmpty(), "The B2_ACCOUNT_ID environment variable is empty, please use B2_APPLICATION_KEY_ID instead.");
            applicationKeyId = accountId;
        }
        B2Preconditions.checkState(applicationKeyId != null, "B2_APPLICATION_KEY_ID must be set in the environment");
        B2Preconditions.checkState(!applicationKeyId.isEmpty(), "B2_APPLICATION_KEY_ID must be non-empty.");
        return applicationKeyId;
    }
}

