/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.contentSources;

import com.backblaze.b2.util.B2Preconditions;
import com.backblaze.b2.util.B2StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public interface B2Headers {
    public static final String FILE_ID = "X-Bz-File-Id";
    public static final String FILE_NAME = "X-Bz-File-Name";
    public static final String CONTENT_SHA1 = "X-Bz-Content-Sha1";
    public static final String TEST_MODE = "X-Bz-Test-Mode";
    public static final String PART_NUMBER = "X-Bz-Part-Number";
    public static final String UPLOAD_TIMESTAMP = "X-Bz-Upload-Timestamp";
    public static final String FILE_INFO_PREFIX = "X-Bz-Info-";
    public static final String HEX_DIGITS_AT_END = "hex_digits_at_end";
    public static final String SRC_LAST_MODIFIED_MILLIS_INFO_NAME = "src_last_modified_millis";
    public static final String SRC_LAST_MODIFIED_MILLIS = "X-Bz-Info-src_last_modified_millis";
    public static final String LARGE_FILE_SHA1_INFO_NAME = "large_file_sha1";
    public static final String LARGE_FILE_SHA1 = "X-Bz-Info-large_file_sha1";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String RANGE = "Range";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String USER_AGENT = "User-Agent";
    public static final String EXPECT = "Expect";
    public static final String CLIENT_UNAUTHORIZED_TO_READ = "X-Bz-Client-Unauthorized-To-Read";
    public static final String FILE_RETENTION_MODE = "X-Bz-File-Retention-Mode";
    public static final String FILE_RETENTION_RETAIN_UNTIL_TIMESTAMP = "X-Bz-File-Retention-Retain-Until-Timestamp";
    public static final String FILE_LEGAL_HOLD = "X-Bz-File-Legal-Hold";
    public static final String SERVER_SIDE_ENCRYPTION = "X-Bz-Server-Side-Encryption";
    public static final String SERVER_SIDE_ENCRYPTION_CUSTOMER_ALGORITHM = "X-Bz-Server-Side-Encryption-Customer-Algorithm";
    public static final String SERVER_SIDE_ENCRYPTION_CUSTOMER_KEY = "X-Bz-Server-Side-Encryption-Customer-Key";
    public static final String SERVER_SIDE_ENCRYPTION_CUSTOMER_KEY_MD5 = "X-Bz-Server-Side-Encryption-Customer-Key-Md5";
    public static final String REPLICATION_STATUS = "X-Bz-Replication-Status";

    public Collection<String> getNames();

    public String getValueOrNull(String var1);

    default public String getContentType() {
        String str = this.getValueOrNull(CONTENT_TYPE);
        return str != null ? str : "application/octet";
    }

    default public long getContentLength() {
        String str = this.getValueOrNull(CONTENT_LENGTH);
        B2Preconditions.checkState(str != null, "don't call if there isn't a Content-Length!");
        try {
            return Long.parseLong(str);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("can't parse Content-Length '" + str + "' as a long: " + e, e);
        }
    }

    default public String getFileNameOrNull() {
        String str = this.getValueOrNull(FILE_NAME);
        if (str == null) {
            return null;
        }
        try {
            return B2StringUtil.percentDecode(str);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    default public Long getUploadTimestampOrNull() {
        String str = this.getValueOrNull(UPLOAD_TIMESTAMP);
        if (str == null) {
            return null;
        }
        try {
            return Long.parseLong(str);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    default public boolean hasContentRange() {
        return this.getValueOrNull(CONTENT_RANGE) != null;
    }

    default public String getContentSha1OrNull() {
        return this.getValueOrNull(CONTENT_SHA1);
    }

    default public String getContentMd5OrNull() {
        return this.getValueOrNull(CONTENT_MD5);
    }

    default public String getContentSha1EvenIfUnverifiedOrNull() {
        String unverifiedPrefix = "unverified:";
        String s = this.getContentSha1OrNull();
        if (s != null && s.startsWith("unverified:")) {
            return s.substring("unverified:".length());
        }
        return s;
    }

    default public String getLargeFileSha1OrNull() {
        return this.getValueOrNull(LARGE_FILE_SHA1);
    }

    default public Map<String, String> getB2FileInfo() {
        TreeMap<String, String> info = new TreeMap<String, String>();
        for (String name : this.getNames()) {
            if (!B2StringUtil.startsWithIgnoreCase(name, FILE_INFO_PREFIX)) continue;
            String shortName = name.substring(FILE_INFO_PREFIX.length());
            info.put(shortName, B2StringUtil.percentDecode(this.getValueOrNull(name)));
        }
        return info;
    }

    default public Long getSrcLastModifiedMillis() {
        String str = this.getValueOrNull(SRC_LAST_MODIFIED_MILLIS);
        if (str == null) {
            return null;
        }
        try {
            return Long.parseLong(str);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    default public List<String> getClientUnauthorizedToReadHeaderList() {
        String unauthorizedHeaders = this.getValueOrNull(CLIENT_UNAUTHORIZED_TO_READ);
        if (unauthorizedHeaders == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(unauthorizedHeaders.split(","));
    }

    default public boolean isClientUnauthorizedToReadFileRetention() {
        return this.getClientUnauthorizedToReadHeaderList().contains(FILE_RETENTION_MODE);
    }

    default public String getFileRetentionModeOrNull() {
        return this.getValueOrNull(FILE_RETENTION_MODE);
    }

    default public Long getFileRetentionRetainUntilTimestampOrNull() {
        String str = this.getValueOrNull(FILE_RETENTION_RETAIN_UNTIL_TIMESTAMP);
        if (str == null) {
            return null;
        }
        try {
            return Long.parseLong(str);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    default public boolean isClientUnauthorizedToReadLegalHold() {
        return this.getClientUnauthorizedToReadHeaderList().contains(FILE_LEGAL_HOLD);
    }

    default public String getFileLegalHoldOrNull() {
        return this.getValueOrNull(FILE_LEGAL_HOLD);
    }

    default public String getServerSideEncryptionOrNull() {
        return this.getValueOrNull(SERVER_SIDE_ENCRYPTION);
    }

    default public String getSseCustomerAlgorithmOrNull() {
        return this.getValueOrNull(SERVER_SIDE_ENCRYPTION_CUSTOMER_ALGORITHM);
    }

    default public String getSseCustomerKeyMd5OrNull() {
        return this.getValueOrNull(SERVER_SIDE_ENCRYPTION_CUSTOMER_KEY_MD5);
    }

    default public String getReplicationStatusOrNull() {
        return this.getValueOrNull(REPLICATION_STATUS);
    }
}

