/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.contentHandlers;

import com.backblaze.b2.client.contentHandlers.B2ContentWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class B2ContentOutputStreamWriter
extends B2ContentWriter {
    private final Helper helper;

    private B2ContentOutputStreamWriter(Helper helper) {
        super(helper.shouldVerifySha1ByRereadingFromDestination());
        this.helper = helper;
    }

    public static Builder builder(Helper helper) {
        return new Builder(helper);
    }

    @Override
    protected OutputStream createDestinationOutputStream() throws IOException {
        return this.helper.createOutputStream();
    }

    @Override
    protected InputStream createDestinationInputStream() throws IOException {
        return this.helper.createInputStream();
    }

    @Override
    protected void succeeded() {
        this.helper.succeeded();
    }

    @Override
    protected void failed() {
        this.helper.failed();
    }

    public static class Builder {
        private final Helper helper;

        private Builder(Helper helper) {
            this.helper = helper;
        }

        public B2ContentOutputStreamWriter build() {
            return new B2ContentOutputStreamWriter(this.helper);
        }
    }

    public static interface Helper {
        public OutputStream createOutputStream() throws IOException;

        default public boolean shouldVerifySha1ByRereadingFromDestination() {
            return false;
        }

        default public InputStream createInputStream() throws IOException {
            throw new RuntimeException("if you override shouldVerifySha1ByRereadingFromDestination() to return true, you need to implement createInputStream() too.");
        }

        default public void succeeded() {
        }

        default public void failed() {
        }
    }
}

