/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2FilePolicy;
import com.backblaze.b2.client.B2ListFilesIterable;
import com.backblaze.b2.client.B2ListKeysIterable;
import com.backblaze.b2.client.B2ListPartsIterable;
import com.backblaze.b2.client.B2PartStorer;
import com.backblaze.b2.client.B2StorageClientWebifier;
import com.backblaze.b2.client.contentHandlers.B2ContentSink;
import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.structures.B2AccountAuthorization;
import com.backblaze.b2.client.structures.B2ApplicationKey;
import com.backblaze.b2.client.structures.B2Bucket;
import com.backblaze.b2.client.structures.B2CancelLargeFileRequest;
import com.backblaze.b2.client.structures.B2CopyFileRequest;
import com.backblaze.b2.client.structures.B2CreateBucketRequest;
import com.backblaze.b2.client.structures.B2CreateKeyRequest;
import com.backblaze.b2.client.structures.B2CreatedApplicationKey;
import com.backblaze.b2.client.structures.B2DeleteBucketRequest;
import com.backblaze.b2.client.structures.B2DeleteFileVersionRequest;
import com.backblaze.b2.client.structures.B2DeleteKeyRequest;
import com.backblaze.b2.client.structures.B2DownloadAuthorization;
import com.backblaze.b2.client.structures.B2DownloadByIdRequest;
import com.backblaze.b2.client.structures.B2DownloadByNameRequest;
import com.backblaze.b2.client.structures.B2FileVersion;
import com.backblaze.b2.client.structures.B2FinishLargeFileRequest;
import com.backblaze.b2.client.structures.B2GetDownloadAuthorizationRequest;
import com.backblaze.b2.client.structures.B2GetFileInfoByNameRequest;
import com.backblaze.b2.client.structures.B2GetFileInfoRequest;
import com.backblaze.b2.client.structures.B2GetUploadPartUrlRequest;
import com.backblaze.b2.client.structures.B2GetUploadUrlRequest;
import com.backblaze.b2.client.structures.B2HideFileRequest;
import com.backblaze.b2.client.structures.B2ListBucketsRequest;
import com.backblaze.b2.client.structures.B2ListBucketsResponse;
import com.backblaze.b2.client.structures.B2ListFileNamesRequest;
import com.backblaze.b2.client.structures.B2ListFileVersionsRequest;
import com.backblaze.b2.client.structures.B2ListKeysRequest;
import com.backblaze.b2.client.structures.B2ListPartsRequest;
import com.backblaze.b2.client.structures.B2ListUnfinishedLargeFilesRequest;
import com.backblaze.b2.client.structures.B2StartLargeFileRequest;
import com.backblaze.b2.client.structures.B2StoreLargeFileRequest;
import com.backblaze.b2.client.structures.B2UpdateBucketRequest;
import com.backblaze.b2.client.structures.B2UpdateFileLegalHoldRequest;
import com.backblaze.b2.client.structures.B2UpdateFileLegalHoldResponse;
import com.backblaze.b2.client.structures.B2UpdateFileRetentionRequest;
import com.backblaze.b2.client.structures.B2UpdateFileRetentionResponse;
import com.backblaze.b2.client.structures.B2UploadFileRequest;
import com.backblaze.b2.client.structures.B2UploadListener;
import com.backblaze.b2.client.structures.B2UploadPartUrlResponse;
import com.backblaze.b2.client.structures.B2UploadUrlResponse;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public interface B2StorageClient
extends Closeable {
    public String getAccountId() throws B2Exception;

    public B2FilePolicy getFilePolicy() throws B2Exception;

    public B2Bucket createBucket(B2CreateBucketRequest var1) throws B2Exception;

    default public B2Bucket createBucket(String bucketName, String bucketType) throws B2Exception {
        return this.createBucket(B2CreateBucketRequest.builder(bucketName, bucketType).build());
    }

    public B2CreatedApplicationKey createKey(B2CreateKeyRequest var1) throws B2Exception;

    public B2ListKeysIterable applicationKeys(B2ListKeysRequest var1) throws B2Exception;

    public B2ApplicationKey deleteKey(B2DeleteKeyRequest var1) throws B2Exception;

    default public B2ListKeysIterable applicationKeys() throws B2Exception {
        return this.applicationKeys(B2ListKeysRequest.builder().build());
    }

    default public B2ListBucketsResponse listBuckets() throws B2Exception {
        String accountId = this.getAccountId();
        return this.listBuckets(B2ListBucketsRequest.builder(accountId).build());
    }

    public B2ListBucketsResponse listBuckets(B2ListBucketsRequest var1) throws B2Exception;

    default public List<B2Bucket> buckets() throws B2Exception {
        return this.listBuckets().getBuckets();
    }

    default public B2Bucket getBucketOrNullByName(String name) throws B2Exception {
        String accountId = this.getAccountId();
        B2ListBucketsRequest request = B2ListBucketsRequest.builder(accountId).setBucketName(name).build();
        List<B2Bucket> buckets = this.listBuckets(request).getBuckets();
        return buckets.isEmpty() ? null : buckets.get(0);
    }

    public B2FileVersion uploadSmallFile(B2UploadFileRequest var1) throws B2Exception;

    public B2FileVersion copySmallFile(B2CopyFileRequest var1) throws B2Exception;

    public B2FileVersion uploadLargeFile(B2UploadFileRequest var1, ExecutorService var2) throws B2Exception;

    public B2FileVersion storeLargeFileFromLocalContent(B2FileVersion var1, B2ContentSource var2, B2UploadListener var3, ExecutorService var4) throws B2Exception;

    public B2FileVersion storeLargeFileFromLocalContent(B2StoreLargeFileRequest var1, B2ContentSource var2, B2UploadListener var3, ExecutorService var4) throws B2Exception;

    public CompletableFuture<B2FileVersion> storeLargeFileFromLocalContentAsync(B2FileVersion var1, B2ContentSource var2, B2UploadListener var3, ExecutorService var4) throws B2Exception;

    public CompletableFuture<B2FileVersion> storeLargeFileFromLocalContentAsync(B2StoreLargeFileRequest var1, B2ContentSource var2, B2UploadListener var3, ExecutorService var4) throws B2Exception;

    public B2FileVersion storeLargeFile(B2FileVersion var1, List<B2PartStorer> var2, B2UploadListener var3, ExecutorService var4) throws B2Exception;

    public B2FileVersion storeLargeFile(B2StoreLargeFileRequest var1, List<B2PartStorer> var2, B2UploadListener var3, ExecutorService var4) throws B2Exception;

    public B2FileVersion finishUploadingLargeFile(B2FileVersion var1, B2UploadFileRequest var2, ExecutorService var3) throws B2Exception;

    public B2ListFilesIterable fileVersions(B2ListFileVersionsRequest var1) throws B2Exception;

    default public B2ListFilesIterable fileVersions(String bucketId) throws B2Exception {
        return this.fileVersions(B2ListFileVersionsRequest.builder(bucketId).setMaxFileCount(1000).build());
    }

    public B2ListFilesIterable fileNames(B2ListFileNamesRequest var1) throws B2Exception;

    default public B2ListFilesIterable fileNames(String bucketId) throws B2Exception {
        return this.fileNames(B2ListFileNamesRequest.builder(bucketId).setMaxFileCount(1000).build());
    }

    public B2ListFilesIterable unfinishedLargeFiles(B2ListUnfinishedLargeFilesRequest var1) throws B2Exception;

    default public B2ListFilesIterable unfinishedLargeFiles(String bucketId) throws B2Exception {
        return this.unfinishedLargeFiles(B2ListUnfinishedLargeFilesRequest.builder(bucketId).setMaxFileCount(100).build());
    }

    public B2ListPartsIterable parts(B2ListPartsRequest var1) throws B2Exception;

    default public B2ListPartsIterable parts(String largeFileId) throws B2Exception {
        return this.parts(B2ListPartsRequest.builder(largeFileId).setMaxPartCount(100).build());
    }

    public void cancelLargeFile(B2CancelLargeFileRequest var1) throws B2Exception;

    default public void cancelLargeFile(String largeFileId) throws B2Exception {
        this.cancelLargeFile(B2CancelLargeFileRequest.builder(largeFileId).build());
    }

    public void downloadById(B2DownloadByIdRequest var1, B2ContentSink var2) throws B2Exception;

    default public void downloadById(String fileId, B2ContentSink handler) throws B2Exception {
        this.downloadById(B2DownloadByIdRequest.builder(fileId).build(), handler);
    }

    public void downloadByName(B2DownloadByNameRequest var1, B2ContentSink var2) throws B2Exception;

    default public void downloadByName(String bucketName, String fileName, B2ContentSink handler) throws B2Exception {
        this.downloadByName(B2DownloadByNameRequest.builder(bucketName, fileName).build(), handler);
    }

    public void deleteFileVersion(B2DeleteFileVersionRequest var1) throws B2Exception;

    default public void deleteFileVersion(B2FileVersion version) throws B2Exception {
        this.deleteFileVersion(version.getFileName(), version.getFileId());
    }

    default public void deleteFileVersion(String fileName, String fileId) throws B2Exception {
        this.deleteFileVersion(B2DeleteFileVersionRequest.builder(fileName, fileId).build());
    }

    default public void deleteAllFilesInBucket(String bucketId) throws B2Exception {
        for (B2FileVersion fileVersion : this.fileNames(bucketId)) {
            this.deleteFileVersion(fileVersion);
        }
    }

    public B2DownloadAuthorization getDownloadAuthorization(B2GetDownloadAuthorizationRequest var1) throws B2Exception;

    public B2FileVersion getFileInfo(B2GetFileInfoRequest var1) throws B2Exception;

    default public B2FileVersion getFileInfo(String fileId) throws B2Exception {
        return this.getFileInfo(B2GetFileInfoRequest.builder(fileId).build());
    }

    public B2FileVersion getFileInfoByName(B2GetFileInfoByNameRequest var1) throws B2Exception;

    default public B2FileVersion getFileInfoByName(String bucketName, String fileName) throws B2Exception {
        return this.getFileInfoByName(B2GetFileInfoByNameRequest.builder(bucketName, fileName).build());
    }

    public B2FileVersion hideFile(B2HideFileRequest var1) throws B2Exception;

    default public B2FileVersion hideFile(String bucketId, String fileName) throws B2Exception {
        return this.hideFile(B2HideFileRequest.builder(bucketId, fileName).build());
    }

    public B2Bucket updateBucket(B2UpdateBucketRequest var1) throws B2Exception;

    public B2Bucket deleteBucket(B2DeleteBucketRequest var1) throws B2Exception;

    default public B2Bucket deleteBucket(String bucketId) throws B2Exception {
        return this.deleteBucket(B2DeleteBucketRequest.builder(bucketId).build());
    }

    public String getDownloadByIdUrl(B2DownloadByIdRequest var1) throws B2Exception;

    default public String getDownloadByIdUrl(String fileId) throws B2Exception {
        return this.getDownloadByIdUrl(B2DownloadByIdRequest.builder(fileId).build());
    }

    public String getDownloadByNameUrl(B2DownloadByNameRequest var1) throws B2Exception;

    default public String getDownloadByNameUrl(String bucketName, String fileName) throws B2Exception {
        return this.getDownloadByNameUrl(B2DownloadByNameRequest.builder(bucketName, fileName).build());
    }

    public B2AccountAuthorization getAccountAuthorization() throws B2Exception;

    public void invalidateAccountAuthorization();

    public B2UploadUrlResponse getUploadUrl(B2GetUploadUrlRequest var1) throws B2Exception;

    public B2UploadPartUrlResponse getUploadPartUrl(B2GetUploadPartUrlRequest var1) throws B2Exception;

    public B2FileVersion startLargeFile(B2StartLargeFileRequest var1) throws B2Exception;

    public B2FileVersion finishLargeFile(B2FinishLargeFileRequest var1) throws B2Exception;

    public B2UpdateFileLegalHoldResponse updateFileLegalHold(B2UpdateFileLegalHoldRequest var1) throws B2Exception;

    public B2UpdateFileRetentionResponse updateFileRetention(B2UpdateFileRetentionRequest var1) throws B2Exception;

    @Override
    public void close();

    public B2StorageClientWebifier getWebifier();
}

