/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2FilePolicy;
import com.backblaze.b2.client.B2PartSpec;
import com.backblaze.b2.client.structures.B2AccountAuthorization;
import com.backblaze.b2.util.B2Preconditions;
import java.util.ArrayList;
import java.util.List;

class B2PartSizes
implements B2FilePolicy {
    private final long MAX_SMALL_FILE_BYTES = 5000000000L;
    private final long minimumPartSize;
    private final long recommendedPartSize;

    private B2PartSizes(long minimumPartSize, long recommendedPartSize) {
        this.minimumPartSize = minimumPartSize;
        this.recommendedPartSize = recommendedPartSize;
    }

    static B2PartSizes from(B2AccountAuthorization auth) {
        return new B2PartSizes(auth.getAbsoluteMinimumPartSize(), auth.getRecommendedPartSize());
    }

    long getMinimumPartSize() {
        return this.minimumPartSize;
    }

    long getRecommendedPartSize() {
        return this.recommendedPartSize;
    }

    @Override
    public boolean mustBeLargeFile(long contentLength) {
        return contentLength > 5000000000L;
    }

    @Override
    public boolean couldBeLargeFile(long contentLength) {
        return contentLength > this.minimumPartSize;
    }

    @Override
    public boolean shouldBeLargeFile(long contentLength) {
        return contentLength >= 2L * this.recommendedPartSize;
    }

    List<B2PartSpec> pickParts(long contentLength) {
        long lastPartSize;
        long partSize;
        int partCount;
        B2Preconditions.checkArgument(this.couldBeLargeFile(contentLength), "contentLength=" + contentLength + " is too small to make at least two parts.  minimumPartSize=" + this.minimumPartSize);
        if (contentLength < 2L * this.minimumPartSize) {
            partCount = 2;
            partSize = this.minimumPartSize;
            lastPartSize = contentLength - this.minimumPartSize;
        } else if (contentLength < 2L * this.recommendedPartSize) {
            partCount = 2;
            partSize = (contentLength + 1L) / (long)partCount;
            lastPartSize = contentLength - partSize;
        } else {
            partCount = Math.min(10000, (int)(contentLength / this.recommendedPartSize));
            lastPartSize = contentLength - (long)(partCount - 1) * (partSize = contentLength / (long)partCount);
            B2Preconditions.checkState(lastPartSize >= partSize);
        }
        B2Preconditions.checkState(partCount >= 2);
        B2Preconditions.checkState(partSize >= this.minimumPartSize);
        B2Preconditions.checkState(lastPartSize >= 1L);
        ArrayList<B2PartSpec> parts = new ArrayList<B2PartSpec>();
        for (int i = 0; i < partCount - 1; ++i) {
            parts.add(new B2PartSpec(i + 1, (long)i * partSize, partSize));
        }
        parts.add(new B2PartSpec(partCount, contentLength - lastPartSize, lastPartSize));
        return parts;
    }
}

