/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2ListPartsIterable;
import com.backblaze.b2.client.B2StorageClientImpl;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.exceptions.B2RuntimeException;
import com.backblaze.b2.client.structures.B2ListPartsResponse;
import com.backblaze.b2.client.structures.B2Part;
import com.backblaze.b2.util.B2Preconditions;
import java.util.Iterator;

public abstract class B2ListPartsIterableBase
implements B2ListPartsIterable {
    private final B2StorageClientImpl b2Client;

    B2ListPartsIterableBase(B2StorageClientImpl b2Client) {
        this.b2Client = b2Client;
    }

    @Override
    public Iterator<B2Part> iterator() {
        try {
            return this.createIter();
        }
        catch (B2Exception e) {
            throw new B2RuntimeException("failed to create/advance iterator: " + e.getMessage(), e);
        }
    }

    protected B2StorageClientImpl getClient() {
        return this.b2Client;
    }

    abstract Iterator<B2Part> createIter() throws B2Exception;

    protected abstract class IterBase
    implements Iterator<B2Part> {
        private int currentIndex;

        IterBase() throws B2Exception {
            this.advanceIfNeeded();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.getCurrentResponseSize();
        }

        @Override
        public B2Part next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("don't call when hasNext() returns false!");
            }
            B2Part part = this.getIthCurrentResponse(this.currentIndex);
            ++this.currentIndex;
            try {
                this.advanceIfNeeded();
            }
            catch (B2Exception e) {
                throw new B2RuntimeException("failed to advance iterator: " + e.getMessage(), e);
            }
            return part;
        }

        private void advanceIfNeeded() throws B2Exception {
            if (this.hasNext()) {
                return;
            }
            if (this.getCurrentResponseOrNull() != null && this.getCurrentResponseOrNull().atEnd()) {
                return;
            }
            this.advance();
            this.currentIndex = 0;
        }

        private int getCurrentResponseSize() {
            B2ListPartsResponse response = this.getCurrentResponseOrNull();
            return response == null ? 0 : response.getParts().size();
        }

        private B2Part getIthCurrentResponse(int i) {
            B2ListPartsResponse response = this.getCurrentResponseOrNull();
            B2Preconditions.checkState(response != null);
            return response.getParts().get(i);
        }

        protected abstract B2ListPartsResponse getCurrentResponseOrNull();

        protected abstract void advance() throws B2Exception;
    }
}

