/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2AccountAuthorizationCache;
import com.backblaze.b2.client.B2ByteProgressFilteringListener;
import com.backblaze.b2.client.B2CancellationToken;
import com.backblaze.b2.client.B2ContentSourceWithByteProgressListener;
import com.backblaze.b2.client.B2PartOfContentSource;
import com.backblaze.b2.client.B2PartSizes;
import com.backblaze.b2.client.B2PartSpec;
import com.backblaze.b2.client.B2PartStorer;
import com.backblaze.b2.client.B2RetryPolicy;
import com.backblaze.b2.client.B2Retryer;
import com.backblaze.b2.client.B2StorageClientWebifier;
import com.backblaze.b2.client.B2UploadPartUrlCache;
import com.backblaze.b2.client.B2UploadProgressAdapter;
import com.backblaze.b2.client.B2UploadingPartStorer;
import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.exceptions.B2CannotComputeException;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.exceptions.B2LocalException;
import com.backblaze.b2.client.structures.B2CopyPartRequest;
import com.backblaze.b2.client.structures.B2FileSseForRequest;
import com.backblaze.b2.client.structures.B2FileVersion;
import com.backblaze.b2.client.structures.B2FinishLargeFileRequest;
import com.backblaze.b2.client.structures.B2Part;
import com.backblaze.b2.client.structures.B2StoreLargeFileRequest;
import com.backblaze.b2.client.structures.B2UploadListener;
import com.backblaze.b2.client.structures.B2UploadPartRequest;
import com.backblaze.b2.client.structures.B2UploadPartUrlResponse;
import com.backblaze.b2.client.structures.B2UploadProgress;
import com.backblaze.b2.client.structures.B2UploadState;
import com.backblaze.b2.util.B2ByteRange;
import com.backblaze.b2.util.B2Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;

public class B2LargeFileStorer {
    private final B2FileVersion fileVersion;
    private final B2FileSseForRequest serverSideEncryptionOrNull;
    private final List<B2PartStorer> partStorers;
    private final List<Long> startingBytePositions;
    private final B2CancellationToken cancellationToken = new B2CancellationToken();
    private final B2AccountAuthorizationCache accountAuthCache;
    private final B2UploadPartUrlCache uploadPartUrlCache;
    private final B2StorageClientWebifier webifier;
    private final B2Retryer retryer;
    private final Supplier<B2RetryPolicy> retryPolicySupplier;
    private final ExecutorService executor;

    B2LargeFileStorer(B2StoreLargeFileRequest storeLargeFileRequest, List<B2PartStorer> partStorers, B2AccountAuthorizationCache accountAuthCache, B2StorageClientWebifier webifier, B2Retryer retryer, Supplier<B2RetryPolicy> retryPolicySupplier, ExecutorService executor) {
        B2Preconditions.checkArgumentIsNotNull(storeLargeFileRequest, "storeLargeFileRequest");
        this.fileVersion = storeLargeFileRequest.getFileVersion();
        this.serverSideEncryptionOrNull = storeLargeFileRequest.getServerSideEncryption();
        this.partStorers = this.validateAndSortPartStorers(new ArrayList<B2PartStorer>(partStorers));
        this.startingBytePositions = B2LargeFileStorer.computeStartingBytePositions(partStorers);
        this.accountAuthCache = accountAuthCache;
        this.uploadPartUrlCache = new B2UploadPartUrlCache(webifier, accountAuthCache, this.fileVersion.getFileId());
        this.webifier = webifier;
        this.retryer = retryer;
        this.retryPolicySupplier = retryPolicySupplier;
        this.executor = executor;
    }

    private List<B2PartStorer> validateAndSortPartStorers(List<B2PartStorer> partStorers) {
        partStorers.sort(Comparator.comparingInt(B2PartStorer::getPartNumber));
        for (int i = 0; i < partStorers.size(); ++i) {
            int expectedPartNumber = i + 1;
            int partNumber = partStorers.get(i).getPartNumber();
            if (partNumber < 1) {
                throw new IllegalArgumentException("invalid part number: " + partNumber);
            }
            if (partNumber < expectedPartNumber) {
                throw new IllegalArgumentException("part number " + partNumber + " has multiple part storers");
            }
            if (partNumber <= expectedPartNumber) continue;
            throw new IllegalArgumentException("part number " + expectedPartNumber + " has no part storers");
        }
        return partStorers;
    }

    private static List<Long> computeStartingBytePositions(List<B2PartStorer> partStorers) {
        ArrayList<Long> startingPositions = new ArrayList<Long>(partStorers.size());
        long cursor = 0L;
        try {
            for (B2PartStorer partStorer : partStorers) {
                startingPositions.add(cursor);
                cursor += partStorer.getPartSizeOrThrow();
            }
        }
        catch (B2CannotComputeException e) {
            while (startingPositions.size() < partStorers.size()) {
                startingPositions.add(-1L);
            }
        }
        return startingPositions;
    }

    List<B2PartStorer> getPartStorers() {
        return this.partStorers;
    }

    long getStartByteOrUnknown(int partNumber) {
        return this.startingBytePositions.get(partNumber - 1);
    }

    public static B2LargeFileStorer forLocalContent(B2FileVersion largeFileVersion, B2ContentSource contentSource, B2PartSizes partSizes, B2AccountAuthorizationCache accountAuthCache, B2StorageClientWebifier webifier, B2Retryer retryer, Supplier<B2RetryPolicy> retryPolicySupplier, ExecutorService executor) throws B2Exception {
        return B2LargeFileStorer.forLocalContent(B2StoreLargeFileRequest.builder(largeFileVersion).build(), contentSource, partSizes, accountAuthCache, webifier, retryer, retryPolicySupplier, executor);
    }

    public static B2LargeFileStorer forLocalContent(B2StoreLargeFileRequest storeLargeFileRequest, B2ContentSource contentSource, B2PartSizes partSizes, B2AccountAuthorizationCache accountAuthCache, B2StorageClientWebifier webifier, B2Retryer retryer, Supplier<B2RetryPolicy> retryPolicySupplier, ExecutorService executor) throws B2Exception {
        B2Preconditions.checkArgumentIsNotNull(storeLargeFileRequest, "storeLargeFileRequest");
        ArrayList<B2PartStorer> partContentSources = new ArrayList<B2PartStorer>();
        try {
            for (B2PartSpec partSpec : partSizes.pickParts(contentSource.getContentLength())) {
                B2UploadingPartStorer localPartContentSource = new B2UploadingPartStorer(partSpec.getPartNumber(), B2LargeFileStorer.createRangedContentSource(contentSource, partSpec.getStart(), partSpec.getLength()));
                partContentSources.add(localPartContentSource);
            }
        }
        catch (IOException e) {
            throw new B2LocalException("trouble", "exception working with content source" + e, e);
        }
        return new B2LargeFileStorer(storeLargeFileRequest, partContentSources, accountAuthCache, webifier, retryer, retryPolicySupplier, executor);
    }

    B2FileVersion storeFile(B2UploadListener uploadListenerOrNull) throws B2Exception {
        try {
            return this.storeFileAsync(uploadListenerOrNull).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof B2Exception) {
                throw (B2Exception)cause;
            }
            throw new B2LocalException("trouble", "exception while trying to upload parts: " + cause, cause);
        }
        catch (InterruptedException e) {
            throw new B2LocalException("trouble", "interrupted exception");
        }
    }

    CompletableFuture<B2FileVersion> storeFileAsync(B2UploadListener uploadListenerOrNull) {
        B2UploadListener uploadListener = uploadListenerOrNull == null ? B2UploadListener.noopListener() : uploadListenerOrNull;
        ArrayList<CompletableFuture<B2Part>> completableFutures = new ArrayList<CompletableFuture<B2Part>>();
        for (B2PartStorer partStorer : this.partStorers) {
            CompletableFuture<B2Part> future = CompletableFuture.supplyAsync(this.adaptB2Supplier(() -> partStorer.storePart(this, uploadListener, this.cancellationToken)), this.executor);
            completableFutures.add(future);
        }
        CompletableFuture<Void> allPartsCompletedFuture = CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0]));
        ArrayList partFutures = new ArrayList(completableFutures);
        CompletionStage retval = allPartsCompletedFuture.thenApplyAsync(voidParam -> this.finishLargeFileFromB2PartFuturesInCompletionStage(this.fileVersion, partFutures), (Executor)this.executor);
        ((CompletableFuture)retval).whenComplete((result, error) -> {
            if (error != null) {
                completableFutures.forEach(x -> x.cancel(true));
                this.cancellationToken.cancel();
            }
        });
        return retval;
    }

    private B2FileVersion finishLargeFileFromB2PartFuturesInCompletionStage(B2FileVersion largeFileVersion, List<Future<B2Part>> partFutures) {
        return this.callSupplierAndConvertErrorsForCompletableFutures(() -> this.finishLargeFileFromB2PartFutures(largeFileVersion, partFutures));
    }

    <Type> Type callSupplierAndConvertErrorsForCompletableFutures(B2Supplier<Type> supplier) {
        try {
            return supplier.get();
        }
        catch (B2Exception | IOException error) {
            throw new CompletionException(error);
        }
    }

    private <Type> Supplier<Type> adaptB2Supplier(B2Supplier<Type> supplier) {
        return () -> this.callSupplierAndConvertErrorsForCompletableFutures(supplier);
    }

    private B2FileVersion finishLargeFileFromB2PartFutures(B2FileVersion largeFileVersion, List<Future<B2Part>> partFutures) throws B2Exception {
        this.cancellationToken.throwIfCancelled();
        ArrayList<String> partSha1s = new ArrayList<String>();
        try {
            for (Future<B2Part> partFuture : partFutures) {
                B2Part part = partFuture.get();
                partSha1s.add(part.getContentSha1());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new B2LocalException("interrupted", "interrupted while trying to copy parts: " + e, e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof B2Exception) {
                throw (B2Exception)e.getCause();
            }
            throw new B2LocalException("trouble", "exception while trying to upload parts: " + cause, cause);
        }
        finally {
            for (Future<B2Part> future : partFutures) {
                future.cancel(true);
            }
        }
        B2FinishLargeFileRequest finishRequest = B2FinishLargeFileRequest.builder(largeFileVersion.getFileId(), partSha1s).build();
        return this.retryer.doRetry("b2_finish_large_file", this.accountAuthCache, () -> this.webifier.finishLargeFile(this.accountAuthCache.get(), finishRequest), this.retryPolicySupplier.get());
    }

    void updateProgress(B2UploadListener uploadListener, int partNumber, long partLength, long bytesSoFar, B2UploadState uploadState) {
        uploadListener.progress(new B2UploadProgress(partNumber - 1, this.partStorers.size(), this.getStartByteOrUnknown(partNumber), partLength, bytesSoFar, uploadState));
    }

    B2Part uploadPart(int partNumber, B2ContentSource contentSource, B2UploadListener uploadListener, B2CancellationToken cancellationToken) throws IOException, B2Exception {
        this.updateProgress(uploadListener, partNumber, contentSource.getContentLength(), 0L, B2UploadState.WAITING_TO_START);
        B2UploadProgressAdapter progressAdapter = new B2UploadProgressAdapter(uploadListener, partNumber - 1, this.partStorers.size(), this.getStartByteOrUnknown(partNumber), contentSource.getContentLength());
        B2ByteProgressFilteringListener progressListener = new B2ByteProgressFilteringListener(progressAdapter);
        try {
            return this.retryer.doRetry("b2_upload_part", this.accountAuthCache, isRetry -> {
                cancellationToken.throwIfCancelled();
                B2UploadPartUrlResponse uploadPartUrlResponse = this.uploadPartUrlCache.get(isRetry);
                B2ContentSourceWithByteProgressListener contentSourceThatReportsProgress = new B2ContentSourceWithByteProgressListener(contentSource, progressListener);
                B2UploadPartRequest uploadPartRequest = B2UploadPartRequest.builder(partNumber, contentSourceThatReportsProgress).setServerSideEncryption(this.serverSideEncryptionOrNull).build();
                this.updateProgress(uploadListener, partNumber, contentSource.getContentLength(), 0L, B2UploadState.STARTING);
                B2Part part = this.webifier.uploadPart(uploadPartUrlResponse, uploadPartRequest);
                this.uploadPartUrlCache.unget(uploadPartUrlResponse);
                this.updateProgress(uploadListener, partNumber, part.getContentLength(), part.getContentLength(), B2UploadState.SUCCEEDED);
                return part;
            }, this.retryPolicySupplier.get());
        }
        catch (B2Exception e) {
            this.updateProgress(uploadListener, partNumber, contentSource.getContentLength(), 0L, B2UploadState.FAILED);
            throw e;
        }
    }

    B2Part copyPart(int partNumber, String sourceFileId, B2ByteRange byteRangeOrNull, B2UploadListener uploadListener, B2CancellationToken cancellationToken) throws B2Exception {
        this.updateProgress(uploadListener, partNumber, 1L, 0L, B2UploadState.WAITING_TO_START);
        B2CopyPartRequest copyPartRequest = B2CopyPartRequest.builder(partNumber, sourceFileId, this.fileVersion.getFileId()).setRange(byteRangeOrNull).build();
        try {
            return this.retryer.doRetry("b2_copy_part", this.accountAuthCache, () -> {
                cancellationToken.throwIfCancelled();
                this.updateProgress(uploadListener, partNumber, 1L, 0L, B2UploadState.STARTING);
                B2Part part = this.webifier.copyPart(this.accountAuthCache.get(), copyPartRequest);
                this.updateProgress(uploadListener, partNumber, part.getContentLength(), part.getContentLength(), B2UploadState.SUCCEEDED);
                return part;
            }, this.retryPolicySupplier.get());
        }
        catch (B2Exception e) {
            this.updateProgress(uploadListener, partNumber, 1L, 0L, B2UploadState.FAILED);
            throw e;
        }
    }

    static B2ContentSource createRangedContentSource(B2ContentSource contentSource, long start, long length) throws IOException {
        B2ContentSource contentSourceWithRangeOrNull = contentSource.createContentSourceWithRangeOrNull(start, length);
        if (contentSourceWithRangeOrNull != null) {
            return contentSourceWithRangeOrNull;
        }
        return new B2PartOfContentSource(contentSource, start, length);
    }

    private static interface B2Supplier<Type> {
        public Type get() throws B2Exception, IOException;
    }
}

