/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2AccountAuthorizer;
import com.backblaze.b2.client.B2StorageClientWebifier;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.exceptions.B2LocalException;
import com.backblaze.b2.client.structures.B2AccountAuthorization;

class B2AccountAuthorizationCache {
    private final B2StorageClientWebifier webifier;
    private final B2AccountAuthorizer accountAuthorizer;
    private B2AccountAuthorization authorization;
    private String accountId;

    B2AccountAuthorizationCache(B2StorageClientWebifier webifier, B2AccountAuthorizer accountAuthorizer) {
        this.webifier = webifier;
        this.accountAuthorizer = accountAuthorizer;
    }

    synchronized B2AccountAuthorization get() throws B2Exception {
        if (this.authorization == null) {
            this.authorization = this.accountAuthorizer.authorize(this.webifier);
            String accountIdFromAuthorization = this.authorization.getAccountId();
            if (this.accountId == null) {
                this.accountId = accountIdFromAuthorization;
            } else if (!this.accountId.equals(accountIdFromAuthorization)) {
                throw new B2LocalException("unauthorized", "authorized as " + accountIdFromAuthorization + "but previously authorized as accountId " + this.accountId);
            }
        }
        return this.authorization;
    }

    synchronized String getAccountId() throws B2Exception {
        if (this.accountId == null) {
            this.get();
        }
        return this.accountId;
    }

    synchronized void clear() {
        this.authorization = null;
    }
}

