/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.util.ReferenceManager;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Objects;

public final class ReferenceManagerImpl
implements ReferenceManager {
    private static final ClientLogger LOGGER = new ClientLogger(ReferenceManagerImpl.class);
    private static final String BASE_THREAD_NAME = "azure-sdk-referencemanager";
    private final CleanableReference<?> cleanableReferenceList;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();

    public ReferenceManagerImpl() {
        this.cleanableReferenceList = new CleanableReference();
        Thread thread = new Thread(this::clearReferenceQueue, BASE_THREAD_NAME);
        new CleanableReference<ReferenceManagerImpl>(this, () -> {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevel.WARNING, () -> "Failed to shutdown ReferenceManager thread.", e);
            }
        }, this);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void register(Object object, Runnable cleanupAction) {
        new CleanableReference<Object>(Objects.requireNonNull(object, "'object' cannot be null."), Objects.requireNonNull(cleanupAction, "'cleanupAction' cannot be null."), this);
    }

    void clearReferenceQueue() {
        while (this.cleanableReferenceList.hasRemaining()) {
            CleanableReference reference = null;
            try {
                reference = (CleanableReference)this.queue.remove(30000L);
            }
            catch (InterruptedException ex) {
                LOGGER.log(LogLevel.VERBOSE, () -> "ReferenceManager Thread interrupted while waiting for a reference to clean.", ex);
            }
            try {
                if (reference == null) continue;
                reference.clean();
            }
            catch (Throwable ex) {
                LOGGER.log(LogLevel.INFORMATIONAL, () -> "Cleaning a reference threw an exception.", ex);
            }
        }
    }

    static int getJavaImplementationMajorVersion() {
        return 8;
    }

    private static final class CleanableReference<T>
    extends PhantomReference<T> {
        private final Runnable cleanupAction;
        private final CleanableReference<?> cleanupList;
        CleanableReference<?> previous = this;
        CleanableReference<?> next = this;

        CleanableReference() {
            super(null, null);
            this.cleanupAction = null;
            this.cleanupList = this;
        }

        CleanableReference(T referent, Runnable cleanupAction, ReferenceManagerImpl manager) {
            super(referent, manager.queue);
            this.cleanupAction = cleanupAction;
            this.cleanupList = manager.cleanableReferenceList;
            this.insert();
        }

        public void clean() {
            if (this.remove()) {
                super.clear();
                this.cleanupAction.run();
            }
        }

        @Override
        public void clear() {
            if (this.remove()) {
                super.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasRemaining() {
            CleanableReference<?> cleanableReference = this.cleanupList;
            synchronized (cleanableReference) {
                return this.cleanupList != this.cleanupList.next;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insert() {
            CleanableReference<?> cleanableReference = this.cleanupList;
            synchronized (cleanableReference) {
                this.previous = this.cleanupList;
                this.next = this.cleanupList.next;
                this.next.previous = this;
                this.cleanupList.next = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean remove() {
            CleanableReference<?> cleanableReference = this.cleanupList;
            synchronized (cleanableReference) {
                if (this.next != this) {
                    this.next.previous = this.previous;
                    this.previous.next = this.next;
                    this.previous = this;
                    this.next = this;
                    return true;
                }
                return false;
            }
        }
    }
}

