/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.ErrorOptions;
import com.azure.core.http.rest.UrlEscapers;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Consumer;

public final class RequestOptions {
    private static final ClientLogger LOGGER = new ClientLogger(RequestOptions.class);
    private static final EnumSet<ErrorOptions> DEFAULT = EnumSet.of(ErrorOptions.THROW);
    private Consumer<HttpRequest> requestCallback = request -> {};
    private EnumSet<ErrorOptions> errorOptions = DEFAULT;
    private Context context;

    Consumer<HttpRequest> getRequestCallback() {
        return this.requestCallback;
    }

    EnumSet<ErrorOptions> getErrorOptions() {
        return this.errorOptions;
    }

    Context getContext() {
        return this.context;
    }

    public RequestOptions addHeader(String header, String value) {
        this.requestCallback = this.requestCallback.andThen(request -> request.getHeaders().add(header, value));
        return this;
    }

    public RequestOptions setHeader(String header, String value) {
        this.requestCallback = this.requestCallback.andThen(request -> request.getHeaders().set(header, value));
        return this;
    }

    public RequestOptions addQueryParam(String parameterName, String value) {
        return this.addQueryParam(parameterName, value, false);
    }

    public RequestOptions addQueryParam(String parameterName, String value, boolean encoded) {
        this.requestCallback = this.requestCallback.andThen(request -> {
            String url = request.getUrl().toString();
            String encodedParameterName = encoded ? parameterName : UrlEscapers.QUERY_ESCAPER.escape(parameterName);
            String encodedParameterValue = encoded ? value : UrlEscapers.QUERY_ESCAPER.escape(value);
            request.setUrl(url + (url.contains("?") ? "&" : "?") + encodedParameterName + "=" + encodedParameterValue);
        });
        return this;
    }

    public RequestOptions addRequestCallback(Consumer<HttpRequest> requestCallback) {
        Objects.requireNonNull(requestCallback, "'requestCallback' cannot be null.");
        this.requestCallback = this.requestCallback.andThen(requestCallback);
        return this;
    }

    public RequestOptions setBody(BinaryData requestBody) {
        Objects.requireNonNull(requestBody, "'requestBody' cannot be null.");
        this.requestCallback = this.requestCallback.andThen(request -> request.setBody(requestBody.toBytes()));
        return this;
    }

    public RequestOptions setErrorOptions(EnumSet<ErrorOptions> errorOptions) {
        Objects.requireNonNull(errorOptions, "'errorOptions' cannot be null.");
        if (errorOptions.contains((Object)ErrorOptions.THROW) && errorOptions.contains((Object)ErrorOptions.NO_THROW)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'errorOptions' cannot contain both 'ErrorOptions.THROW' and 'ErrorOptions.NO_THROW'."));
        }
        this.errorOptions = errorOptions;
        return this;
    }

    public RequestOptions setContext(Context context) {
        this.context = context;
        return this;
    }
}

