/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.inet.sftp;

import com.jscape.inet.file.JAcl;
import com.jscape.inet.file.JAcl$Mask;
import com.jscape.inet.file.JFile;
import com.jscape.inet.file.JFileFilter;
import com.jscape.inet.file.JFileOpenFlags;
import com.jscape.inet.file.JFileOutputStream;
import com.jscape.inet.file.JFilePermissions;
import com.jscape.inet.file.JFileSystem;
import com.jscape.inet.file.JFileType;
import com.jscape.inet.file.JRandomAccessFile;
import com.jscape.inet.file.WildcardFileFilter;
import com.jscape.inet.sftp.RequestException;
import com.jscape.inet.sftp.SftpClient;
import com.jscape.inet.sftp.SftpException;
import com.jscape.inet.sftp.SftpPacket;
import com.jscape.inet.sftp.SftpRandomAccessFile;
import com.jscape.inet.sftp.packets.SftpFileAttributes;
import com.jscape.inet.sftp.packets.SftpName;
import com.jscape.inet.sftp.packets.SshFxpStatus;
import com.jscape.util.i;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;

public class SftpFile
implements JFile {
    protected static final char PATH_SEPARATOR = '/';
    protected static final String CURRENT_DIR = ".";
    protected static final String PARENT_DIR;
    protected SftpFile parent = null;
    protected String path = null;
    protected SftpFileAttributes attrs = null;
    protected final SftpClient client;
    private static final String[] z;

    public SftpFile(String string, SftpClient sftpClient) {
        i.a((Object)string);
        i.a(sftpClient);
        this.path = string;
        this.client = sftpClient;
        this.initAbsolutePath();
    }

    public SftpFile(SftpFile sftpFile, String string, SftpClient sftpClient) {
        this(sftpFile, string, null, sftpClient);
        this.initAbsolutePath();
    }

    protected SftpFile(SftpFile sftpFile, String string, SftpFileAttributes sftpFileAttributes, SftpClient sftpClient) {
        i.a(sftpFile);
        i.a((Object)string);
        i.a(sftpClient);
        this.parent = sftpFile;
        String string2 = sftpFile.getPath();
        StringBuilder stringBuilder = new StringBuilder().append(string2);
        String string3 = string2;
        if (SftpPacket.c == 0) {
            string3 = string3.endsWith(String.valueOf('/')) ? string : '/' + string;
        }
        this.path = stringBuilder.append(string3).toString();
        this.attrs = sftpFileAttributes;
        this.client = sftpClient;
    }

    public String getFilename() {
        String string = this.getPath();
        int n2 = string.lastIndexOf(47);
        return n2 >= 0 ? string.substring(n2 + 1) : string;
    }

    public String getPath() {
        return this.path;
    }

    public JFile getParentFile() {
        String string;
        int n2;
        SftpFile sftpFile = this.parent;
        if (SftpPacket.c == 0) {
            if (sftpFile != null) {
                return this.parent;
            }
            sftpFile = this;
        }
        String string2 = (n2 = (string = sftpFile.getPath()).lastIndexOf(47)) >= 0 ? string.substring(0, n2) : string;
        return this.client.getFile(string2);
    }

    public JFileType getType() throws SftpException {
        return this.getPermissions().getType();
    }

    public boolean isDirectory() throws SftpException {
        block8: {
            SftpFile sftpFile;
            int n2;
            block7: {
                JFileType jFileType;
                JFileType jFileType2;
                block6: {
                    n2 = SftpPacket.c;
                    jFileType2 = this.getType();
                    jFileType = JFileType.DIRECTORY;
                    if (n2 != 0) break block6;
                    if (jFileType2 == jFileType) {
                        return true;
                    }
                    sftpFile = this;
                    if (n2 != 0) break block7;
                    jFileType2 = sftpFile.getType();
                    jFileType = JFileType.SYMBOLIC;
                }
                if (jFileType2 != jFileType) break block8;
                sftpFile = this;
            }
            int n3 = sftpFile.getFilename().indexOf(CURRENT_DIR);
            if (n2 == 0) {
                if (n3 != -1) {
                    return false;
                }
                n3 = 1;
            }
            return n3 != 0;
        }
        return false;
    }

    public long getFilesize() throws SftpException {
        this.ensureAttributesInit();
        return this.attrs.getSize();
    }

    public String getOwner() throws SftpException {
        this.ensureAttributesInit();
        return Integer.toString(this.attrs.getUid());
    }

    public void setOwner(String string) throws SftpException {
        i.a((Object)string);
        this.ensureAttributesInit();
        this.attrs.setUid(Integer.parseInt(string));
        this.setAttributes();
    }

    public String getGroup() throws SftpException {
        this.ensureAttributesInit();
        return Integer.toString(this.attrs.getGid());
    }

    public void setGroup(String string) throws SftpException {
        i.a((Object)string);
        this.ensureAttributesInit();
        this.attrs.setGid(Integer.parseInt(string));
        this.setAttributes();
    }

    public JFilePermissions getPermissions() throws SftpException {
        this.ensureAttributesInit();
        return this.attrs.getPermissions();
    }

    public String getPermission() throws SftpException {
        return this.getPermissions().toString();
    }

    public void setPermissions(JFilePermissions jFilePermissions) throws SftpException {
        i.a(jFilePermissions);
        this.ensureAttributesInit();
        this.attrs.setPermissions(jFilePermissions);
        this.setAttributes();
    }

    public long getAccessTime() throws SftpException {
        this.ensureAttributesInit();
        return this.attrs.getAtime();
    }

    public long getAccessTimeNsec() throws SftpException {
        throw new SftpException(z[1]);
    }

    public long getCreationTime() throws SftpException {
        throw new SftpException(z[0]);
    }

    public long getCreationTimeNsec() throws SftpException {
        throw new SftpException(z[1]);
    }

    public long getModificationTime() throws SftpException {
        this.ensureAttributesInit();
        return this.attrs.getMtime();
    }

    public long getModificationTimeNsec() throws SftpException {
        throw new SftpException(z[1]);
    }

    public Date getDate() throws SftpException {
        return new Date(this.getModificationTime() * 1000L);
    }

    public String getTime() throws SftpException {
        return Long.toString(this.getDate().getTime());
    }

    public JAcl[] getAcl() throws SftpException {
        throw new SftpException(z[0]);
    }

    public void setAcl(JAcl[] jAclArray) throws SftpException {
        throw new SftpException(z[0]);
    }

    public boolean isReadOnly() throws SftpException {
        throw new SftpException(z[0]);
    }

    public boolean isSystem() throws SftpException {
        throw new SftpException(z[0]);
    }

    public boolean isHidden() throws SftpException {
        throw new SftpException(z[0]);
    }

    public boolean isCaseInsensitive() throws SftpException {
        throw new SftpException(z[0]);
    }

    public boolean isArchive() throws SftpException {
        throw new SftpException(z[0]);
    }

    public void setArchive(boolean bl) throws SftpException {
        throw new SftpException(z[0]);
    }

    public boolean isEncrypted() throws SftpException {
        throw new SftpException(z[0]);
    }

    public boolean isCompressed() throws SftpException {
        throw new SftpException(z[0]);
    }

    public boolean isSparse() throws SftpException {
        throw new SftpException(z[0]);
    }

    public boolean isAppendOnly() throws SftpException {
        throw new SftpException(z[0]);
    }

    public boolean isImmutable() throws SftpException {
        throw new SftpException(z[0]);
    }

    public void setImmutable(boolean bl) throws SftpException {
        throw new SftpException(z[0]);
    }

    public boolean isSync() throws SftpException {
        throw new SftpException(z[0]);
    }

    public void setSync(boolean bl) throws SftpException {
        throw new SftpException(z[0]);
    }

    public boolean exists() throws SftpException {
        try {
            this.initAttributes();
            return true;
        }
        catch (RequestException requestException) {
            return false;
        }
    }

    public void createNewFile() throws SftpException {
        if (this.exists()) {
            return;
        }
        try {
            JFileOutputStream jFileOutputStream = new JFileOutputStream(this);
            jFileOutputStream.close();
            this.initAbsolutePath();
        }
        catch (IOException iOException) {
            throw new SftpException(iOException.getMessage());
        }
    }

    public void createNewDirectory() throws SftpException {
        SftpFile sftpFile = this;
        if (SftpPacket.c == 0) {
            if (sftpFile.exists()) {
                return;
            }
            this.client.mkdir(this.path, new SftpFileAttributes());
            sftpFile = this;
        }
        sftpFile.initAbsolutePath();
    }

    public void createNewLink(JFile jFile) throws SftpException {
        throw new SftpException(z[0]);
    }

    public void renameTo(JFile jFile) throws SftpException {
        i.a(jFile);
        throw new SftpException(z[0]);
    }

    public void delete() throws SftpException {
        block7: {
            SftpFile sftpFile;
            block5: {
                block6: {
                    boolean bl;
                    int n2;
                    block4: {
                        n2 = SftpPacket.c;
                        bl = this.exists();
                        if (n2 != 0) break block4;
                        if (!bl) {
                            return;
                        }
                        sftpFile = this;
                        if (n2 != 0) break block5;
                        bl = sftpFile.isDirectory();
                    }
                    if (!bl) break block6;
                    this.client.rmdir(this.path);
                    if (n2 == 0) break block7;
                }
                sftpFile = this;
            }
            sftpFile.client.remove(this.path);
        }
    }

    public void deleteRecursive() throws SftpException {
        block8: {
            SftpFile sftpFile;
            block5: {
                SftpFile sftpFile2;
                int n2;
                block6: {
                    block7: {
                        n2 = SftpPacket.c;
                        sftpFile2 = this;
                        if (n2 != 0) break block6;
                        if (sftpFile2.isDirectory()) break block7;
                        this.delete();
                        if (n2 == 0) break block8;
                    }
                    sftpFile2 = this;
                }
                JFile[] jFileArray = sftpFile2.listFiles();
                for (int i2 = 0; i2 < jFileArray.length; ++i2) {
                    SftpFile sftpFile3;
                    sftpFile = sftpFile3 = (SftpFile)jFileArray[i2];
                    if (n2 == 0) {
                        SftpFile sftpFile4;
                        if (n2 == 0) {
                            if (sftpFile.isDirectory()) {
                                sftpFile3.deleteRecursive();
                                if (n2 == 0) continue;
                            }
                            sftpFile4 = sftpFile3;
                        }
                        sftpFile4.delete();
                        if (n2 == 0) continue;
                    }
                    break block5;
                }
                sftpFile = this;
            }
            sftpFile.delete();
        }
    }

    public JFile[] listFiles() throws SftpException {
        return this.listFiles(new WildcardFileFilter("*"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFile[] listFiles(JFileFilter jFileFilter) throws SftpException {
        int n2 = SftpPacket.c;
        i.a(jFileFilter);
        byte[] byArray = this.client.opendir(this.path);
        try {
            List list;
            block5: {
                SftpName[] sftpNameArray;
                list = new LinkedList<SftpName>();
                while ((sftpNameArray = this.client.readdir(byArray)) != null) {
                    list.addAll(Arrays.asList(sftpNameArray));
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block5;
                }
                list = this.convertToFiles(list, jFileFilter);
            }
            JFile[] jFileArray = list.toArray(new JFile[list.size()]);
            return jFileArray;
        }
        finally {
            this.client.close(byArray);
        }
    }

    public JFile getLinkTarget() throws SftpException {
        throw new SftpException(z[0]);
    }

    public JRandomAccessFile getRandomAccessFile(JFileOpenFlags jFileOpenFlags, JAcl$Mask jAcl$Mask) throws SftpException {
        i.a(jFileOpenFlags);
        i.a(jAcl$Mask);
        return new SftpRandomAccessFile(this, jFileOpenFlags, jAcl$Mask);
    }

    public JFileSystem getFileSystem() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this.getPermission()).append(' ');
            stringBuffer.append(this.getOwner()).append(' ');
            stringBuffer.append(this.getGroup()).append(' ');
            stringBuffer.append(this.getFilesize()).append(' ');
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(z[2]);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(z[3]));
            stringBuffer.append(simpleDateFormat.format(this.getDate())).append(' ');
        }
        catch (Exception exception) {
        }
        finally {
            stringBuffer.append(this.getFilename());
        }
        return stringBuffer.toString();
    }

    protected void initAbsolutePath() {
    }

    protected void ensureAttributesInit() throws SftpException {
        block3: {
            SftpFile sftpFile;
            block2: {
                sftpFile = this;
                if (SftpPacket.c != 0) break block2;
                if (sftpFile.attrs != null) break block3;
                sftpFile = this;
            }
            sftpFile.initAttributes();
        }
    }

    protected void initAttributes() throws SftpException {
        block2: {
            try {
                this.attrs = this.client.lstat(this.path);
            }
            catch (RequestException requestException) {
                if (!(requestException.getResponse() instanceof SshFxpStatus)) break block2;
                this.attrs = this.client.stat(this.path);
            }
        }
    }

    protected void setAttributes() throws SftpException {
        this.client.setStat(this.path, this.attrs);
        this.initAttributes();
    }

    protected List convertToFiles(List list, JFileFilter jFileFilter) {
        int n2 = SftpPacket.c;
        ArrayList<JFile> arrayList = new ArrayList<JFile>();
        for (SftpName sftpName : list) {
            block6: {
                boolean bl;
                JFile jFile;
                block7: {
                    block5: {
                        jFile = this.client.getFile(this, sftpName.getFileName(this.client.getCharset()), sftpName.getAttrs());
                        bl = jFile.getFilename().equals(CURRENT_DIR);
                        if (n2 != 0) break block5;
                        if (bl) break block6;
                        bl = jFile.getFilename().equals(PARENT_DIR);
                    }
                    if (n2 != 0) break block7;
                    if (bl) break block6;
                    bl = jFileFilter.accepts(jFile);
                }
                if (n2 == 0 && bl) {
                    bl = arrayList.add(jFile);
                }
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block49: {
            int n2;
            int n3;
            block48: {
                char[] cArray2;
                Object var0;
                block47: {
                    int n4;
                    block46: {
                        char[] cArray3;
                        block45: {
                            int n5;
                            block44: {
                                char[] cArray4;
                                block43: {
                                    int n6;
                                    block42: {
                                        char[] cArray5;
                                        block41: {
                                            int n7;
                                            block40: {
                                                stringArray = new String[4];
                                                var0 = null;
                                                char[] cArray6 = "0\f".toCharArray();
                                                cArray5 = cArray6;
                                                n7 = cArray6.length;
                                                n3 = 0;
                                                if (!true) break block40;
                                                n7 = n7;
                                                if (n7 <= n3) break block41;
                                            }
                                            do {
                                                int n8;
                                                cArray5 = cArray5;
                                                int n9 = n3;
                                                char c2 = cArray5[n9];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n8 = 30;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n8 = 34;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n8 = 44;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n8 = 39;
                                                        break;
                                                    }
                                                    default: {
                                                        n8 = 40;
                                                    }
                                                }
                                                cArray5[n9] = (char)(c2 ^ n8);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        PARENT_DIR = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray7 = "kL_RXnM^SMz\u0002CWMlCXNGp".toCharArray();
                                        cArray4 = cArray7;
                                        n6 = cArray7.length;
                                        n3 = 0;
                                        if (!true) break block42;
                                        n6 = n6;
                                        if (n6 <= n3) break block43;
                                    }
                                    do {
                                        int n10;
                                        cArray4 = cArray4;
                                        int n11 = n3;
                                        char c3 = cArray4[n11];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n10 = 30;
                                                break;
                                            }
                                            case 1: {
                                                n10 = 34;
                                                break;
                                            }
                                            case 2: {
                                                n10 = 44;
                                                break;
                                            }
                                            case 3: {
                                                n10 = 39;
                                                break;
                                            }
                                            default: {
                                                n10 = 40;
                                            }
                                        }
                                        cArray4[n11] = (char)(c3 ^ n10);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[0] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray8 = "pMX\u0007XlG_BFj".toCharArray();
                                cArray3 = cArray8;
                                n5 = cArray8.length;
                                n3 = 0;
                                if (!true) break block44;
                                n5 = n5;
                                if (n5 <= n3) break block45;
                            }
                            do {
                                int n12;
                                cArray3 = cArray3;
                                int n13 = n3;
                                char c4 = cArray3[n13];
                                switch (n3 % 5) {
                                    case 0: {
                                        n12 = 30;
                                        break;
                                    }
                                    case 1: {
                                        n12 = 34;
                                        break;
                                    }
                                    case 2: {
                                        n12 = 44;
                                        break;
                                    }
                                    case 3: {
                                        n12 = 39;
                                        break;
                                    }
                                    default: {
                                        n12 = 40;
                                    }
                                }
                                cArray3[n13] = (char)(c4 ^ n12);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[1] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray9 = "Soa\u0007Lz\u0002U^Qg\u0002GL\u0012sO".toCharArray();
                        cArray2 = cArray9;
                        n4 = cArray9.length;
                        n3 = 0;
                        if (!true) break block46;
                        n4 = n4;
                        if (n4 <= n3) break block47;
                    }
                    do {
                        int n14;
                        cArray2 = cArray2;
                        int n15 = n3;
                        char c5 = cArray2[n15];
                        switch (n3 % 5) {
                            case 0: {
                                n14 = 30;
                                break;
                            }
                            case 1: {
                                n14 = 34;
                                break;
                            }
                            case 2: {
                                n14 = 44;
                                break;
                            }
                            case 3: {
                                n14 = 39;
                                break;
                            }
                            default: {
                                n14 = 40;
                            }
                        }
                        cArray2[n15] = (char)(c5 ^ n14);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[2] = new String(cArray2).intern();
                var0 = null;
                char[] cArray10 = "Yox".toCharArray();
                cArray = cArray10;
                n2 = cArray10.length;
                n3 = 0;
                if (!true) break block48;
                n2 = n2;
                if (n2 <= n3) break block49;
            }
            do {
                int n16;
                cArray = cArray;
                int n17 = n3;
                char c6 = cArray[n17];
                switch (n3 % 5) {
                    case 0: {
                        n16 = 30;
                        break;
                    }
                    case 1: {
                        n16 = 34;
                        break;
                    }
                    case 2: {
                        n16 = 44;
                        break;
                    }
                    case 3: {
                        n16 = 39;
                        break;
                    }
                    default: {
                        n16 = 40;
                    }
                }
                cArray[n17] = (char)(c6 ^ n16);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[3] = new String(cArray).intern();
        z = stringArray;
    }
}

