/*
 * Decompiled with CFR 0.152.
 */
package org.doublecloud.ws.util;

import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypeUtil {
    public static final Class<?> INT_ARRAY_CLASS = int[].class;
    public static final Class<?> BYTE_ARRAY_CLASS = byte[].class;
    public static final Class<?> LONG_ARRAY_CLASS = long[].class;
    private static Log log = LogFactory.getLog(TypeUtil.class);
    private static final Set<String> PRIMITIVE_TYPES = new HashSet<String>();
    private static String[] BASIC_TYPES;
    private static final Package LANG_PKG;
    private static final Package UTIL_PKG;
    private static String PACKAGE_NAME;
    private static final Map<String, Class<?>> VIM_CLASSES;
    private static Class<?>[] clazzes;
    private static String[] xsdStrs;

    public static boolean isPrimitiveType(String type) {
        return PRIMITIVE_TYPES.contains(type);
    }

    public static boolean isBasicType(String type) {
        for (String BASIC_TYPE : BASIC_TYPES) {
            if (!type.startsWith(BASIC_TYPE)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBasicType(Class<?> clazz) {
        Package pkg = clazz.getPackage();
        return pkg == null || pkg == LANG_PKG || pkg == UTIL_PKG;
    }

    public static Class<?> getVimClass(String type) {
        if (VIM_CLASSES.containsKey(type)) {
            return VIM_CLASSES.get(type);
        }
        try {
            Class<?> clazz;
            if (!type.endsWith("[]")) {
                clazz = Class.forName(PACKAGE_NAME + "." + type);
            } else {
                String arrayType = type.substring(0, type.length() - 2);
                clazz = Array.newInstance(TypeUtil.getVimClass(arrayType), 0).getClass();
            }
            VIM_CLASSES.put(type, clazz);
            return clazz;
        }
        catch (ClassNotFoundException cnfe) {
            log.error((Object)("ClassNotFoundException caught for type: " + type), (Throwable)cnfe);
            return null;
        }
    }

    public static String getXSIType(Object obj) {
        Class<?> type = obj.getClass();
        for (int i = 0; i < clazzes.length; ++i) {
            if (type != clazzes[i]) continue;
            return xsdStrs[i];
        }
        if (obj instanceof Calendar) {
            return "xsd:dateTime";
        }
        throw new RuntimeException("Unknown data type during serialization:" + type);
    }

    static {
        PRIMITIVE_TYPES.add("int");
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("short");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("byte");
        PRIMITIVE_TYPES.add("long");
        PRIMITIVE_TYPES.add("double");
        BASIC_TYPES = new String[]{"String", "int", "short", "long", "float", "Float", "byte", "boolean", "Boolean", "Calendar", "double"};
        LANG_PKG = String.class.getPackage();
        UTIL_PKG = Calendar.class.getPackage();
        PACKAGE_NAME = "com.vmware.vim25";
        VIM_CLASSES = new ConcurrentHashMap();
        clazzes = new Class[]{Integer.class, Long.class, Boolean.class, Short.class, Float.class, String.class, Byte.class, Double.class};
        xsdStrs = new String[]{"xsd:int", "xsd:long", "xsd:boolean", "xsd:short", "xsd:float", "xsd:string", "xsd:byte", "xsd:double"};
    }
}

