/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class ApacheTrustSelfSigned {
    private static Log log = LogFactory.getLog(ApacheTrustSelfSigned.class);

    public static SSLConnectionSocketFactory trust() {
        SSLConnectionSocketFactory sslConnectionSocketFactory;
        SSLContextBuilder builder = new SSLContextBuilder();
        log.trace((Object)"Set SSL Context Builder to trust self signed certs.");
        try {
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            log.trace((Object)"Added Self Signed Strategy to builder.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"NoSuchAlgorithm caught trying to add SelfSignedStrategy.", (Throwable)e);
            return null;
        }
        catch (KeyStoreException e) {
            log.error((Object)"KeyStoreException caught trying to add TrustSelfSignedStrategy.", (Throwable)e);
            return null;
        }
        try {
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build(), (X509HostnameVerifier)new AllowAllHostnameVerifier());
            log.trace((Object)"Added SSLConnectionSocketFactory to builder.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Error trying to trust self signed certs.", (Throwable)e);
            return null;
        }
        catch (KeyManagementException e) {
            log.error((Object)"Error trying to trust self signed certs.", (Throwable)e);
            return null;
        }
        log.trace((Object)"Created self signed trust.");
        return sslConnectionSocketFactory;
    }
}

