/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ws.ApacheTrustSelfSigned;
import com.vmware.vim25.ws.Argument;
import com.vmware.vim25.ws.CustomSSLTrustContextCreator;
import com.vmware.vim25.ws.SoapAction;
import com.vmware.vim25.ws.SoapClient;
import com.vmware.vim25.ws.XmlGen;
import com.vmware.vim25.ws.XmlGenDom;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class ApacheHttpClient
extends SoapClient {
    private static final Log log = LogFactory.getLog(ApacheHttpClient.class);
    private XmlGen xmlGen = new XmlGenDom();
    private boolean trustAllSSL = true;

    public ApacheHttpClient(String serverUrl, boolean ignoreCert) throws MalformedURLException {
        this(serverUrl, ignoreCert, null);
    }

    public ApacheHttpClient(String serverUrl, boolean ignoreCert, TrustManager trustManager) throws MalformedURLException {
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        log.trace((Object)("Creating ApacheHttpClient to server URL: " + serverUrl));
        log.trace((Object)("Ignore ssl: " + ignoreCert));
        this.trustAllSSL = ignoreCert;
        this.trustManager = trustManager;
        this.baseUrl = new URL(serverUrl);
    }

    public ApacheHttpClient(String url) throws MalformedURLException {
        this(url, true);
    }

    @Override
    public Object invoke(String methodName, Argument[] paras, String returnType) throws RemoteException {
        log.trace((Object)("Invoking method: " + methodName));
        String soapMsg = this.marshall(methodName, paras);
        InputStream is = null;
        try {
            is = this.post(soapMsg);
            log.trace((Object)("Converting xml response from server to: " + returnType));
            Object object = this.unMarshall(returnType, is, soapMsg);
            return object;
        }
        catch (Exception e1) {
            log.error((Object)"Exception caught while invoking method.", (Throwable)e1);
            throw new RemoteException("VI SDK invoke exception:" + e1, e1);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public StringBuffer invokeAsString(String methodName, Argument[] paras) throws RemoteException {
        String soapMsg = XmlGen.toXML(methodName, paras, this.vimNameSpace);
        try {
            InputStream is = this.post(soapMsg);
            return this.readStream(is);
        }
        catch (Exception e) {
            throw new RemoteException("VI SDK invoke exception:" + e);
        }
    }

    private InputStream post(String payload) throws IOException {
        Header[] headers;
        HttpPost httpPost;
        StringEntity stringEntity;
        CloseableHttpClient httpclient;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.readTimeout).build();
        if (this.trustAllSSL && this.trustManager != null) {
            log.warn((Object)"The option to ignore certs has been set along with a provided trust manager. This is not a valid scenario and the trust manager will be ignored.");
        }
        if (this.trustAllSSL) {
            httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)ApacheTrustSelfSigned.trust()).build();
        } else if (this.trustManager != null) {
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(CustomSSLTrustContextCreator.getTrustContext(this.trustManager), (X509HostnameVerifier)new AllowAllHostnameVerifier());
            httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
        } else {
            httpclient = HttpClients.createDefault();
        }
        try {
            stringEntity = new StringEntity(payload);
            log.trace((Object)"Converted payload to String entity.");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Failed to convert payload to StringEntity. Unsupported Encoding Exception caught. Payload: " + payload), (Throwable)e);
            return null;
        }
        try {
            httpPost = new HttpPost(this.baseUrl.toURI());
        }
        catch (URISyntaxException e) {
            log.error((Object)("Malformed URI sent: " + this.baseUrl.toString()), (Throwable)e);
            return null;
        }
        httpPost.setConfig(requestConfig);
        httpPost.setHeader(SoapAction.SOAP_ACTION_HEADER.toString(), this.soapAction);
        httpPost.setHeader("Content-Type", "text/xml; charset=utf-8");
        if (this.cookie != null) {
            log.trace((Object)"Setting Cookie.");
            httpPost.setHeader("Cookie", this.cookie);
        }
        httpPost.setEntity((HttpEntity)stringEntity);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        InputStream inputStream = response.getEntity().getContent();
        for (Header header : headers = response.getAllHeaders()) {
            if (!header.getName().equals("Set-Cookie")) continue;
            String newCookie = header.getValue();
            this.setCookie(newCookie, "ApacheHttpClient-post");
            break;
        }
        return inputStream;
    }
}

