/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ProfileConfigInfo;
import com.vmware.vim25.ProfileDescription;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.util.MorUtil;
import java.rmi.RemoteException;
import java.util.Calendar;

public class Profile
extends ManagedObject {
    public Profile(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public String getComplianceStatus() {
        return (String)this.getCurrentProperty("info");
    }

    public ProfileConfigInfo getConfig() {
        return (ProfileConfigInfo)this.getCurrentProperty("config");
    }

    public Calendar getCreatedTime() {
        return (Calendar)this.getCurrentProperty("createdTime");
    }

    public ProfileDescription getDescriptioin() {
        return (ProfileDescription)this.getCurrentProperty("description");
    }

    public ManagedEntity[] getEntity() {
        ManagedObject[] objs = this.getManagedObjects("entity");
        if (objs.length == 0) {
            return new ManagedEntity[0];
        }
        ManagedEntity[] mes = new ManagedEntity[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            mes[i] = (ManagedEntity)objs[i];
        }
        return mes;
    }

    public Calendar getModifiedTime() {
        return (Calendar)this.getCurrentProperty("modifiedTime");
    }

    public String getName() {
        return (String)this.getCurrentProperty("name");
    }

    public void associateProfile(ManagedEntity[] mes) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = MorUtil.createMORs(mes);
        this.getVimService().associateProfile(this.getMOR(), mors);
    }

    public Task checkProfileCompliance_Task(ManagedEntity[] mes) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = MorUtil.createMORs(mes);
        ManagedObjectReference taskMor = this.getVimService().checkProfileCompliance_Task(this.getMOR(), mors);
        return new Task(this.getServerConnection(), taskMor);
    }

    public void destroyProfile() throws RuntimeFault, RemoteException {
        this.getVimService().destroyProfile(this.getMOR());
    }

    public String exportProfile() throws RuntimeFault, RemoteException {
        return this.getVimService().exportProfile(this.getMOR());
    }

    public void dissociateProfile(ManagedEntity[] mes) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = MorUtil.createMORs(mes);
        this.getVimService().dissociateProfile(this.getMOR(), mors);
    }

    public ProfileDescription retrieveDescription() throws RuntimeFault, RemoteException {
        return this.getVimService().retrieveDescription(this.getMOR());
    }
}

