/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AlreadyExists;
import com.vmware.vim25.ClusterIoFilterInfo;
import com.vmware.vim25.FilterInUse;
import com.vmware.vim25.InvalidArgument;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.IoFilterQueryIssueResult;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.VirtualDiskId;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import java.rmi.RemoteException;

public class IoFilterManager
extends ManagedObject {
    public IoFilterManager(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public Task installIoFilter_Task(String vibUrl, ComputeResource compRes) throws AlreadyExists, InvalidArgument, RuntimeFault, RemoteException {
        return new Task(this.getServerConnection(), this.getVimService().installIoFilter_Task(this.getMOR(), vibUrl, compRes.getMOR()));
    }

    public VirtualDiskId[] queryDisksUsingFilter(String filterId, ComputeResource compRes) throws RemoteException, RuntimeFault {
        return this.getVimService().queryDisksUsingFilter(this.getMOR(), filterId, compRes.getMOR());
    }

    public ClusterIoFilterInfo[] queryIoFilterInfo(ComputeResource compRes) throws RemoteException, RuntimeFault {
        return this.getVimService().queryIoFilterInfo(this.getMOR(), compRes.getMOR());
    }

    public IoFilterQueryIssueResult queryIoFilterIssues(String filterId, ComputeResource compRes) throws RemoteException, RuntimeFault {
        return this.getVimService().queryIoFilterIssues(this.getMOR(), filterId, compRes.getMOR());
    }

    public Task resolveInstallationErrorsOnCluster_Task(String filterId, ClusterComputeResource cluster) throws NotFound, RuntimeFault, RemoteException {
        return new Task(this.getServerConnection(), this.getVimService().resolveInstallationErrorsOnCluster_Task(this.getMOR(), filterId, cluster.getMOR()));
    }

    public Task resolveInstallationErrorsOnHost_Task(String filterId, HostSystem host) throws NotFound, RuntimeFault, RemoteException {
        return new Task(this.getServerConnection(), this.getVimService().resolveInstallationErrorsOnHost_Task(this.getMOR(), filterId, host.getMOR()));
    }

    public Task unInstallIoFilter_Task(String filterId, ComputeResource cluster) throws FilterInUse, InvalidArgument, InvalidState, NotFound, RuntimeFault, RemoteException {
        return new Task(this.getServerConnection(), this.getVimService().uninstallIoFilter_Task(this.getMOR(), filterId, cluster.getMOR()));
    }

    public Task upgradeIoFilter_Task(String filterId, ComputeResource cluster, String vibUrl) throws InvalidArgument, InvalidState, NotFound, RuntimeFault, RemoteException {
        return new Task(this.getServerConnection(), this.getVimService().upgradeIoFilter_Task(this.getMOR(), filterId, cluster.getMOR(), vibUrl));
    }
}

