/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.CoreUtils;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluent.models.ManagementLockObjectInner;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.azure.resourcemanager.resources.implementation.ManagementLockImpl;
import com.azure.resourcemanager.resources.models.ManagementLock;
import com.azure.resourcemanager.resources.models.ManagementLocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ManagementLocksImpl
extends CreatableResourcesImpl<ManagementLock, ManagementLockImpl, ManagementLockObjectInner>
implements ManagementLocks {
    private final ResourceManager manager;

    public ManagementLocksImpl(ResourceManager manager) {
        this.manager = manager;
    }

    static String resourceIdFromLockId(String lockId) {
        Object[] lockIdParts = ManagementLocksImpl.lockIdParts(lockId);
        if (CoreUtils.isNullOrEmpty((Object[])lockIdParts)) {
            return null;
        }
        StringBuilder resourceId = new StringBuilder();
        for (int i = 0; i < lockIdParts.length - 4; ++i) {
            if (((String)lockIdParts[i]).isEmpty()) continue;
            resourceId.append("/").append((String)lockIdParts[i]);
        }
        return resourceId.toString();
    }

    private static String[] lockIdParts(String lockId) {
        if (CoreUtils.isNullOrEmpty((CharSequence)lockId)) {
            return new String[0];
        }
        String[] parts = lockId.split("/");
        if (parts.length < 4) {
            return new String[0];
        }
        if (!(parts[parts.length - 2].equalsIgnoreCase("locks") && parts[parts.length - 3].equalsIgnoreCase("Microsoft.Authorization") && parts[parts.length - 4].equalsIgnoreCase("providers"))) {
            return new String[0];
        }
        return parts;
    }

    @Override
    public ManagementLockImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    protected ManagementLockImpl wrapModel(String name) {
        ManagementLockObjectInner inner = new ManagementLockObjectInner();
        return new ManagementLockImpl(name, inner, this.manager());
    }

    @Override
    protected ManagementLockImpl wrapModel(ManagementLockObjectInner inner) {
        if (inner == null) {
            return null;
        }
        return new ManagementLockImpl(inner.name(), inner, this.manager());
    }

    @Override
    public PagedIterable<ManagementLock> list() {
        return this.wrapList(this.manager().managementLockClient().getManagementLocks().list());
    }

    @Override
    public PagedFlux<ManagementLock> listAsync() {
        return this.wrapPageAsync(this.manager().managementLockClient().getManagementLocks().listAsync());
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        String scope = ManagementLocksImpl.resourceIdFromLockId(id);
        String lockName = ResourceUtils.nameFromResourceId(id);
        if (scope != null && lockName != null) {
            return this.manager().managementLockClient().getManagementLocks().deleteByScopeAsync(scope, lockName);
        }
        return Mono.empty();
    }

    @Override
    public PagedIterable<ManagementLock> listByResourceGroup(String resourceGroupName) {
        return this.wrapList(this.manager().managementLockClient().getManagementLocks().listByResourceGroup(resourceGroupName));
    }

    @Override
    public PagedFlux<ManagementLock> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)resourceGroupName)) {
            return new PagedFlux(() -> Mono.error((Throwable)new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return this.wrapPageAsync(this.manager().managementLockClient().getManagementLocks().listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public ManagementLock getByResourceGroup(String resourceGroupName, String name) {
        return (ManagementLock)this.getByResourceGroupAsync(resourceGroupName, name).block();
    }

    @Override
    public Mono<ManagementLock> getByResourceGroupAsync(String resourceGroupName, String name) {
        if (CoreUtils.isNullOrEmpty((CharSequence)resourceGroupName)) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter 'name' is required and cannot be null."));
        }
        return this.manager().managementLockClient().getManagementLocks().getByResourceGroupAsync(resourceGroupName, name).map(this::wrapModel);
    }

    @Override
    public ManagementLock getById(String id) {
        return (ManagementLock)this.getByIdAsync(id).block();
    }

    @Override
    public Mono<ManagementLock> getByIdAsync(String id) {
        String resourceId = ManagementLocksImpl.resourceIdFromLockId(id);
        String lockName = ResourceUtils.nameFromResourceId(id);
        return this.manager().managementLockClient().getManagementLocks().getByScopeAsync(resourceId, lockName).map(this::wrapModel);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String name) {
        this.deleteByResourceGroupAsync(resourceGroupName, name).block();
    }

    @Override
    public Mono<Void> deleteByResourceGroupAsync(String resourceGroupName, String name) {
        if (CoreUtils.isNullOrEmpty((CharSequence)resourceGroupName)) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter 'name' is required and cannot be null."));
        }
        return this.manager().managementLockClient().getManagementLocks().deleteAsync(resourceGroupName, name);
    }

    @Override
    public Flux<String> deleteByIdsAsync(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return Flux.empty();
        }
        return Flux.fromIterable(ids).flatMapDelayError(id -> {
            String lockName = ResourceUtils.nameFromResourceId(id);
            String scopeName = ManagementLocksImpl.resourceIdFromLockId(id);
            return this.manager().managementLockClient().getManagementLocks().deleteByScopeAsync(scopeName, lockName).then(Mono.just((Object)id));
        }, 32, 32);
    }

    @Override
    public Flux<String> deleteByIdsAsync(String ... ids) {
        return this.deleteByIdsAsync(new ArrayList<String>(Arrays.asList(ids)));
    }

    @Override
    public void deleteByIds(Collection<String> ids) {
        this.deleteByIdsAsync(ids).blockLast();
    }

    @Override
    public void deleteByIds(String ... ids) {
        this.deleteByIdsAsync(ids).blockLast();
    }

    @Override
    public ResourceManager manager() {
        return this.manager;
    }

    @Override
    public PagedIterable<ManagementLock> listForResource(String resourceId) {
        return this.wrapList(this.manager().managementLockClient().getManagementLocks().listByScope(resourceId));
    }

    @Override
    public PagedFlux<ManagementLock> listForResourceAsync(String resourceId) {
        return this.wrapPageAsync(this.manager().managementLockClient().getManagementLocks().listByScopeAsync(resourceId));
    }
}

