/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourceCollectionImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.models.ExternalChildResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;

public abstract class ExternalChildResourcesNonCachedImpl<FluentModelTImpl extends ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT>, FluentModelT extends ExternalChildResource<FluentModelT, ParentT>, InnerModelT, ParentImplT extends ParentT, ParentT>
extends ExternalChildResourceCollectionImpl<FluentModelTImpl, FluentModelT, InnerModelT, ParentImplT, ParentT> {
    private ClientLogger logger = new ClientLogger(this.getClass());

    protected ExternalChildResourcesNonCachedImpl(ParentImplT parent, TaskGroup parentTaskGroup, String childResourceName) {
        super(parent, parentTaskGroup, childResourceName);
    }

    protected final FluentModelTImpl prepareIndependentDefine(FluentModelTImpl model) {
        ((ExternalChildResourceImpl)model).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return model;
    }

    protected final FluentModelTImpl prepareInlineDefine(FluentModelTImpl model) {
        Object childResource = this.find(((ExternalChildResourceImpl)model).childResourceKey());
        if (childResource != null) {
            this.pendingOperationException(((ExternalChildResourceImpl)model).name(), ((ExternalChildResourceImpl)model).childResourceKey());
        }
        ((ExternalChildResourceImpl)model).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        this.childCollection.put(((ExternalChildResourceImpl)model).childResourceKey(), model);
        return super.prepareForFutureCommitOrPostRun(model);
    }

    protected final FluentModelTImpl prepareInlineUpdate(FluentModelTImpl model) {
        Object childResource = this.find(((ExternalChildResourceImpl)model).childResourceKey());
        if (childResource != null) {
            this.pendingOperationException(((ExternalChildResourceImpl)model).name(), ((ExternalChildResourceImpl)model).childResourceKey());
        }
        ((ExternalChildResourceImpl)model).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeUpdated);
        this.childCollection.put(((ExternalChildResourceImpl)model).childResourceKey(), model);
        return super.prepareForFutureCommitOrPostRun(model);
    }

    protected final void prepareInlineRemove(FluentModelTImpl model) {
        Object childResource = this.find(((ExternalChildResourceImpl)model).childResourceKey());
        if (childResource != null) {
            this.pendingOperationException(((ExternalChildResourceImpl)model).name(), ((ExternalChildResourceImpl)model).childResourceKey());
        }
        ((ExternalChildResourceImpl)model).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeRemoved);
        this.childCollection.put(((ExternalChildResourceImpl)model).childResourceKey(), model);
        super.prepareForFutureCommitOrPostRun(model);
    }

    @Override
    protected final boolean clearAfterCommit() {
        return true;
    }

    private void pendingOperationException(String name, String key) {
        String errorMessage = String.format("There is already an operation pending on the child resource ('%s') with name (key) '%s (%s)'", this.childResourceName, name, key);
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(errorMessage));
    }
}

