/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceEnvironment;
import com.azure.resourcemanager.appservice.fluent.models.ValidateProperties;
import com.azure.resourcemanager.appservice.models.ValidateResourceTypes;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ValidateRequest {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ValidateRequest.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="type", required=true)
    private ValidateResourceTypes type;
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="properties", required=true)
    private ValidateProperties innerProperties = new ValidateProperties();

    public String name() {
        return this.name;
    }

    public ValidateRequest withName(String name) {
        this.name = name;
        return this;
    }

    public ValidateResourceTypes type() {
        return this.type;
    }

    public ValidateRequest withType(ValidateResourceTypes type) {
        this.type = type;
        return this;
    }

    public String location() {
        return this.location;
    }

    public ValidateRequest withLocation(String location) {
        this.location = location;
        return this;
    }

    private ValidateProperties innerProperties() {
        return this.innerProperties;
    }

    public String serverFarmId() {
        return this.innerProperties() == null ? null : this.innerProperties().serverFarmId();
    }

    public ValidateRequest withServerFarmId(String serverFarmId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withServerFarmId(serverFarmId);
        return this;
    }

    public String skuName() {
        return this.innerProperties() == null ? null : this.innerProperties().skuName();
    }

    public ValidateRequest withSkuName(String skuName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withSkuName(skuName);
        return this;
    }

    public Boolean needLinuxWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().needLinuxWorkers();
    }

    public ValidateRequest withNeedLinuxWorkers(Boolean needLinuxWorkers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withNeedLinuxWorkers(needLinuxWorkers);
        return this;
    }

    public Boolean isSpot() {
        return this.innerProperties() == null ? null : this.innerProperties().isSpot();
    }

    public ValidateRequest withIsSpot(Boolean isSpot) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withIsSpot(isSpot);
        return this;
    }

    public Integer capacity() {
        return this.innerProperties() == null ? null : this.innerProperties().capacity();
    }

    public ValidateRequest withCapacity(Integer capacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withCapacity(capacity);
        return this;
    }

    public String hostingEnvironment() {
        return this.innerProperties() == null ? null : this.innerProperties().hostingEnvironment();
    }

    public ValidateRequest withHostingEnvironment(String hostingEnvironment) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withHostingEnvironment(hostingEnvironment);
        return this;
    }

    public Boolean isXenon() {
        return this.innerProperties() == null ? null : this.innerProperties().isXenon();
    }

    public ValidateRequest withIsXenon(Boolean isXenon) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withIsXenon(isXenon);
        return this;
    }

    public String containerRegistryBaseUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().containerRegistryBaseUrl();
    }

    public ValidateRequest withContainerRegistryBaseUrl(String containerRegistryBaseUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withContainerRegistryBaseUrl(containerRegistryBaseUrl);
        return this;
    }

    public String containerRegistryUsername() {
        return this.innerProperties() == null ? null : this.innerProperties().containerRegistryUsername();
    }

    public ValidateRequest withContainerRegistryUsername(String containerRegistryUsername) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withContainerRegistryUsername(containerRegistryUsername);
        return this;
    }

    public String containerRegistryPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().containerRegistryPassword();
    }

    public ValidateRequest withContainerRegistryPassword(String containerRegistryPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withContainerRegistryPassword(containerRegistryPassword);
        return this;
    }

    public String containerImageRepository() {
        return this.innerProperties() == null ? null : this.innerProperties().containerImageRepository();
    }

    public ValidateRequest withContainerImageRepository(String containerImageRepository) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withContainerImageRepository(containerImageRepository);
        return this;
    }

    public String containerImageTag() {
        return this.innerProperties() == null ? null : this.innerProperties().containerImageTag();
    }

    public ValidateRequest withContainerImageTag(String containerImageTag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withContainerImageTag(containerImageTag);
        return this;
    }

    public String containerImagePlatform() {
        return this.innerProperties() == null ? null : this.innerProperties().containerImagePlatform();
    }

    public ValidateRequest withContainerImagePlatform(String containerImagePlatform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withContainerImagePlatform(containerImagePlatform);
        return this;
    }

    public AppServiceEnvironment appServiceEnvironment() {
        return this.innerProperties() == null ? null : this.innerProperties().appServiceEnvironment();
    }

    public ValidateRequest withAppServiceEnvironment(AppServiceEnvironment appServiceEnvironment) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidateProperties();
        }
        this.innerProperties().withAppServiceEnvironment(appServiceEnvironment);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model ValidateRequest"));
        }
        if (this.type() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model ValidateRequest"));
        }
        if (this.location() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model ValidateRequest"));
        }
        if (this.innerProperties() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ValidateRequest"));
        }
        this.innerProperties().validate();
    }
}

