/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.DetectorDefinition;
import com.azure.resourcemanager.appservice.models.AbnormalTimePeriod;
import com.azure.resourcemanager.appservice.models.AnalysisData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class DiagnosticAnalysisProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DiagnosticAnalysisProperties.class);
    @JsonProperty(value="startTime")
    private OffsetDateTime startTime;
    @JsonProperty(value="endTime")
    private OffsetDateTime endTime;
    @JsonProperty(value="abnormalTimePeriods")
    private List<AbnormalTimePeriod> abnormalTimePeriods;
    @JsonProperty(value="payload")
    private List<AnalysisData> payload;
    @JsonProperty(value="nonCorrelatedDetectors")
    private List<DetectorDefinition> nonCorrelatedDetectors;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public DiagnosticAnalysisProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public DiagnosticAnalysisProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<AbnormalTimePeriod> abnormalTimePeriods() {
        return this.abnormalTimePeriods;
    }

    public DiagnosticAnalysisProperties withAbnormalTimePeriods(List<AbnormalTimePeriod> abnormalTimePeriods) {
        this.abnormalTimePeriods = abnormalTimePeriods;
        return this;
    }

    public List<AnalysisData> payload() {
        return this.payload;
    }

    public DiagnosticAnalysisProperties withPayload(List<AnalysisData> payload) {
        this.payload = payload;
        return this;
    }

    public List<DetectorDefinition> nonCorrelatedDetectors() {
        return this.nonCorrelatedDetectors;
    }

    public DiagnosticAnalysisProperties withNonCorrelatedDetectors(List<DetectorDefinition> nonCorrelatedDetectors) {
        this.nonCorrelatedDetectors = nonCorrelatedDetectors;
        return this;
    }

    public void validate() {
        if (this.abnormalTimePeriods() != null) {
            this.abnormalTimePeriods().forEach(e -> e.validate());
        }
        if (this.payload() != null) {
            this.payload().forEach(e -> e.validate());
        }
        if (this.nonCorrelatedDetectors() != null) {
            this.nonCorrelatedDetectors().forEach(e -> e.validate());
        }
    }
}

