/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.BackupItemStatus;
import com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class BackupItemProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BackupItemProperties.class);
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private Integer backupId;
    @JsonProperty(value="storageAccountUrl", access=JsonProperty.Access.WRITE_ONLY)
    private String storageAccountUrl;
    @JsonProperty(value="blobName", access=JsonProperty.Access.WRITE_ONLY)
    private String blobName;
    @JsonProperty(value="name", access=JsonProperty.Access.WRITE_ONLY)
    private String name;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private BackupItemStatus status;
    @JsonProperty(value="sizeInBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long sizeInBytes;
    @JsonProperty(value="created", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime created;
    @JsonProperty(value="log", access=JsonProperty.Access.WRITE_ONLY)
    private String log;
    @JsonProperty(value="databases", access=JsonProperty.Access.WRITE_ONLY)
    private List<DatabaseBackupSetting> databases;
    @JsonProperty(value="scheduled", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean scheduled;
    @JsonProperty(value="lastRestoreTimeStamp", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastRestoreTimestamp;
    @JsonProperty(value="finishedTimeStamp", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime finishedTimestamp;
    @JsonProperty(value="correlationId", access=JsonProperty.Access.WRITE_ONLY)
    private String correlationId;
    @JsonProperty(value="websiteSizeInBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long websiteSizeInBytes;

    public Integer backupId() {
        return this.backupId;
    }

    public String storageAccountUrl() {
        return this.storageAccountUrl;
    }

    public String blobName() {
        return this.blobName;
    }

    public String name() {
        return this.name;
    }

    public BackupItemStatus status() {
        return this.status;
    }

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public OffsetDateTime created() {
        return this.created;
    }

    public String log() {
        return this.log;
    }

    public List<DatabaseBackupSetting> databases() {
        return this.databases;
    }

    public Boolean scheduled() {
        return this.scheduled;
    }

    public OffsetDateTime lastRestoreTimestamp() {
        return this.lastRestoreTimestamp;
    }

    public OffsetDateTime finishedTimestamp() {
        return this.finishedTimestamp;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public Long websiteSizeInBytes() {
        return this.websiteSizeInBytes;
    }

    public void validate() {
        if (this.databases() != null) {
            this.databases().forEach(e -> e.validate());
        }
    }
}

