/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.KeyVaultKeyReference;
import com.azure.resourcemanager.compute.models.KeyVaultSecretReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class DiskEncryptionSettings {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DiskEncryptionSettings.class);
    @JsonProperty(value="diskEncryptionKey")
    private KeyVaultSecretReference diskEncryptionKey;
    @JsonProperty(value="keyEncryptionKey")
    private KeyVaultKeyReference keyEncryptionKey;
    @JsonProperty(value="enabled")
    private Boolean enabled;

    public KeyVaultSecretReference diskEncryptionKey() {
        return this.diskEncryptionKey;
    }

    public DiskEncryptionSettings withDiskEncryptionKey(KeyVaultSecretReference diskEncryptionKey) {
        this.diskEncryptionKey = diskEncryptionKey;
        return this;
    }

    public KeyVaultKeyReference keyEncryptionKey() {
        return this.keyEncryptionKey;
    }

    public DiskEncryptionSettings withKeyEncryptionKey(KeyVaultKeyReference keyEncryptionKey) {
        this.keyEncryptionKey = keyEncryptionKey;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public DiskEncryptionSettings withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void validate() {
        if (this.diskEncryptionKey() != null) {
            this.diskEncryptionKey().validate();
        }
        if (this.keyEncryptionKey() != null) {
            this.keyEncryptionKey().validate();
        }
    }
}

