/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.AutomaticOSUpgradeProperties;
import com.azure.resourcemanager.compute.models.DataDiskImage;
import com.azure.resourcemanager.compute.models.DisallowedConfiguration;
import com.azure.resourcemanager.compute.models.HyperVGenerationTypes;
import com.azure.resourcemanager.compute.models.OSDiskImage;
import com.azure.resourcemanager.compute.models.PurchasePlan;
import com.azure.resourcemanager.compute.models.VirtualMachineImageFeature;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VirtualMachineImageProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineImageProperties.class);
    @JsonProperty(value="plan")
    private PurchasePlan plan;
    @JsonProperty(value="osDiskImage")
    private OSDiskImage osDiskImage;
    @JsonProperty(value="dataDiskImages")
    private List<DataDiskImage> dataDiskImages;
    @JsonProperty(value="automaticOSUpgradeProperties")
    private AutomaticOSUpgradeProperties automaticOSUpgradeProperties;
    @JsonProperty(value="hyperVGeneration")
    private HyperVGenerationTypes hyperVGeneration;
    @JsonProperty(value="disallowed")
    private DisallowedConfiguration disallowed;
    @JsonProperty(value="features")
    private List<VirtualMachineImageFeature> features;

    public PurchasePlan plan() {
        return this.plan;
    }

    public VirtualMachineImageProperties withPlan(PurchasePlan plan) {
        this.plan = plan;
        return this;
    }

    public OSDiskImage osDiskImage() {
        return this.osDiskImage;
    }

    public VirtualMachineImageProperties withOsDiskImage(OSDiskImage osDiskImage) {
        this.osDiskImage = osDiskImage;
        return this;
    }

    public List<DataDiskImage> dataDiskImages() {
        return this.dataDiskImages;
    }

    public VirtualMachineImageProperties withDataDiskImages(List<DataDiskImage> dataDiskImages) {
        this.dataDiskImages = dataDiskImages;
        return this;
    }

    public AutomaticOSUpgradeProperties automaticOSUpgradeProperties() {
        return this.automaticOSUpgradeProperties;
    }

    public VirtualMachineImageProperties withAutomaticOSUpgradeProperties(AutomaticOSUpgradeProperties automaticOSUpgradeProperties) {
        this.automaticOSUpgradeProperties = automaticOSUpgradeProperties;
        return this;
    }

    public HyperVGenerationTypes hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public VirtualMachineImageProperties withHyperVGeneration(HyperVGenerationTypes hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public DisallowedConfiguration disallowed() {
        return this.disallowed;
    }

    public VirtualMachineImageProperties withDisallowed(DisallowedConfiguration disallowed) {
        this.disallowed = disallowed;
        return this;
    }

    public List<VirtualMachineImageFeature> features() {
        return this.features;
    }

    public VirtualMachineImageProperties withFeatures(List<VirtualMachineImageFeature> features) {
        this.features = features;
        return this;
    }

    public void validate() {
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.osDiskImage() != null) {
            this.osDiskImage().validate();
        }
        if (this.dataDiskImages() != null) {
            this.dataDiskImages().forEach(e -> e.validate());
        }
        if (this.automaticOSUpgradeProperties() != null) {
            this.automaticOSUpgradeProperties().validate();
        }
        if (this.disallowed() != null) {
            this.disallowed().validate();
        }
        if (this.features() != null) {
            this.features().forEach(e -> e.validate());
        }
    }
}

