/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.ResponseBasedOriginErrorDetectionParameters;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class DeepCreatedOriginGroup {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DeepCreatedOriginGroup.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="properties.healthProbeSettings")
    private HealthProbeParameters healthProbeSettings;
    @JsonProperty(value="properties.origins")
    private List<ResourceReference> origins;
    @JsonProperty(value="properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes")
    private Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    @JsonProperty(value="properties.responseBasedOriginErrorDetectionSettings")
    private ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings;

    public String name() {
        return this.name;
    }

    public DeepCreatedOriginGroup withName(String name) {
        this.name = name;
        return this;
    }

    public HealthProbeParameters healthProbeSettings() {
        return this.healthProbeSettings;
    }

    public DeepCreatedOriginGroup withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        this.healthProbeSettings = healthProbeSettings;
        return this;
    }

    public List<ResourceReference> origins() {
        return this.origins;
    }

    public DeepCreatedOriginGroup withOrigins(List<ResourceReference> origins) {
        this.origins = origins;
        return this;
    }

    public Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes() {
        return this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    }

    public DeepCreatedOriginGroup withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
        return this;
    }

    public ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings() {
        return this.responseBasedOriginErrorDetectionSettings;
    }

    public DeepCreatedOriginGroup withResponseBasedOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings) {
        this.responseBasedOriginErrorDetectionSettings = responseBasedOriginErrorDetectionSettings;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model DeepCreatedOriginGroup"));
        }
        if (this.healthProbeSettings() != null) {
            this.healthProbeSettings().validate();
        }
        if (this.origins() != null) {
            this.origins().forEach(e -> e.validate());
        }
        if (this.responseBasedOriginErrorDetectionSettings() != null) {
            this.responseBasedOriginErrorDetectionSettings().validate();
        }
    }
}

