/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.Certificate;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class CustomerCertificate
extends Certificate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CustomerCertificate.class);
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="certificateAuthority")
    private String certificateAuthority;
    @JsonProperty(value="certificateUrl", required=true)
    private String certificateUrl;
    @JsonProperty(value="useLatestVersion")
    private Boolean useLatestVersion;
    @JsonProperty(value="subjectAlternativeNames")
    private List<String> subjectAlternativeNames;

    public String version() {
        return this.version;
    }

    public CustomerCertificate withVersion(String version) {
        this.version = version;
        return this;
    }

    public String certificateAuthority() {
        return this.certificateAuthority;
    }

    public CustomerCertificate withCertificateAuthority(String certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return this;
    }

    public String certificateUrl() {
        return this.certificateUrl;
    }

    public CustomerCertificate withCertificateUrl(String certificateUrl) {
        this.certificateUrl = certificateUrl;
        return this;
    }

    public Boolean useLatestVersion() {
        return this.useLatestVersion;
    }

    public CustomerCertificate withUseLatestVersion(Boolean useLatestVersion) {
        this.useLatestVersion = useLatestVersion;
        return this;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public CustomerCertificate withSubjectAlternativeNames(List<String> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    @Override
    public CustomerCertificate withSubject(String subject) {
        super.withSubject(subject);
        return this;
    }

    @Override
    public CustomerCertificate withExpirationDate(String expirationDate) {
        super.withExpirationDate(expirationDate);
        return this;
    }

    @Override
    public CustomerCertificate withThumbprint(String thumbprint) {
        super.withThumbprint(thumbprint);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.certificateUrl() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property certificateUrl in model CustomerCertificate"));
        }
    }
}

