/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.EndpointsClient;
import com.azure.resourcemanager.cdn.fluent.models.EndpointInner;
import com.azure.resourcemanager.cdn.fluent.models.ResourceUsageInner;
import com.azure.resourcemanager.cdn.fluent.models.ValidateCustomDomainOutputInner;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientImpl;
import com.azure.resourcemanager.cdn.models.EndpointListResult;
import com.azure.resourcemanager.cdn.models.EndpointUpdateParameters;
import com.azure.resourcemanager.cdn.models.LoadParameters;
import com.azure.resourcemanager.cdn.models.PurgeParameters;
import com.azure.resourcemanager.cdn.models.ResourceUsageListResult;
import com.azure.resourcemanager.cdn.models.ValidateCustomDomainInput;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class EndpointsClientImpl
implements EndpointsClient {
    private final ClientLogger logger = new ClientLogger(EndpointsClientImpl.class);
    private final EndpointsService service;
    private final CdnManagementClientImpl client;

    EndpointsClientImpl(CdnManagementClientImpl client) {
        this.service = (EndpointsService)RestProxy.create(EndpointsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EndpointInner>> listByProfileSinglePageAsync(String resourceGroupName, String profileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProfile(this.client.getEndpoint(), resourceGroupName, profileName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EndpointListResult)res.getValue()).value(), ((EndpointListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EndpointInner>> listByProfileSinglePageAsync(String resourceGroupName, String profileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByProfile(this.client.getEndpoint(), resourceGroupName, profileName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EndpointListResult)res.getValue()).value(), ((EndpointListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<EndpointInner> listByProfileAsync(String resourceGroupName, String profileName) {
        return new PagedFlux(() -> this.listByProfileSinglePageAsync(resourceGroupName, profileName), nextLink -> this.listByProfileNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EndpointInner> listByProfileAsync(String resourceGroupName, String profileName, Context context) {
        return new PagedFlux(() -> this.listByProfileSinglePageAsync(resourceGroupName, profileName, context), nextLink -> this.listByProfileNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EndpointInner> listByProfile(String resourceGroupName, String profileName) {
        return new PagedIterable(this.listByProfileAsync(resourceGroupName, profileName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EndpointInner> listByProfile(String resourceGroupName, String profileName, Context context) {
        return new PagedIterable(this.listByProfileAsync(resourceGroupName, profileName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<EndpointInner>> getWithResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EndpointInner>> getWithResponseAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EndpointInner> getAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.getWithResponseAsync(resourceGroupName, profileName, endpointName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((EndpointInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EndpointInner get(String resourceGroupName, String profileName, String endpointName) {
        return (EndpointInner)((Object)this.getAsync(resourceGroupName, profileName, endpointName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<EndpointInner> getWithResponse(String resourceGroupName, String profileName, String endpointName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, profileName, endpointName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (endpoint == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpoint is required and cannot be null."));
        }
        endpoint.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), endpoint, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (endpoint == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpoint is required and cannot be null."));
        }
        endpoint.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), endpoint, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<EndpointInner>, EndpointInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, endpointName, endpoint);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)EndpointInner.class), (Type)((Object)EndpointInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<EndpointInner>, EndpointInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, endpointName, endpoint, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)EndpointInner.class), (Type)((Object)EndpointInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginCreate(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, endpoint).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginCreate(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, endpoint, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EndpointInner> createAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, endpoint).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EndpointInner> createAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, endpoint, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EndpointInner create(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return (EndpointInner)((Object)this.createAsync(resourceGroupName, profileName, endpointName, endpoint).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EndpointInner create(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, Context context) {
        return (EndpointInner)((Object)this.createAsync(resourceGroupName, profileName, endpointName, endpoint, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (endpointUpdateProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointUpdateProperties is required and cannot be null."));
        }
        endpointUpdateProperties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), endpointUpdateProperties, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (endpointUpdateProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointUpdateProperties is required and cannot be null."));
        }
        endpointUpdateProperties.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), endpointUpdateProperties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<EndpointInner>, EndpointInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)EndpointInner.class), (Type)((Object)EndpointInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<EndpointInner>, EndpointInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)EndpointInner.class), (Type)((Object)EndpointInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginUpdate(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginUpdate(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EndpointInner> updateAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EndpointInner> updateAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EndpointInner update(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties) {
        return (EndpointInner)((Object)this.updateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EndpointInner update(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties, Context context) {
        return (EndpointInner)((Object)this.updateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, endpointName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, endpointName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String endpointName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String endpointName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String endpointName) {
        this.deleteAsync(resourceGroupName, profileName, endpointName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String endpointName, Context context) {
        this.deleteAsync(resourceGroupName, profileName, endpointName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.start(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<EndpointInner>, EndpointInner> beginStartAsync(String resourceGroupName, String profileName, String endpointName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, profileName, endpointName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)EndpointInner.class), (Type)((Object)EndpointInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<EndpointInner>, EndpointInner> beginStartAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, profileName, endpointName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)EndpointInner.class), (Type)((Object)EndpointInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginStart(String resourceGroupName, String profileName, String endpointName) {
        return this.beginStartAsync(resourceGroupName, profileName, endpointName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginStart(String resourceGroupName, String profileName, String endpointName, Context context) {
        return this.beginStartAsync(resourceGroupName, profileName, endpointName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EndpointInner> startAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.beginStartAsync(resourceGroupName, profileName, endpointName).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EndpointInner> startAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        return this.beginStartAsync(resourceGroupName, profileName, endpointName, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EndpointInner start(String resourceGroupName, String profileName, String endpointName) {
        return (EndpointInner)((Object)this.startAsync(resourceGroupName, profileName, endpointName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EndpointInner start(String resourceGroupName, String profileName, String endpointName, Context context) {
        return (EndpointInner)((Object)this.startAsync(resourceGroupName, profileName, endpointName, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stop(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.stop(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<EndpointInner>, EndpointInner> beginStopAsync(String resourceGroupName, String profileName, String endpointName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.stopWithResponseAsync(resourceGroupName, profileName, endpointName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)EndpointInner.class), (Type)((Object)EndpointInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<EndpointInner>, EndpointInner> beginStopAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.stopWithResponseAsync(resourceGroupName, profileName, endpointName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)EndpointInner.class), (Type)((Object)EndpointInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginStop(String resourceGroupName, String profileName, String endpointName) {
        return this.beginStopAsync(resourceGroupName, profileName, endpointName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginStop(String resourceGroupName, String profileName, String endpointName, Context context) {
        return this.beginStopAsync(resourceGroupName, profileName, endpointName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EndpointInner> stopAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.beginStopAsync(resourceGroupName, profileName, endpointName).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EndpointInner> stopAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        return this.beginStopAsync(resourceGroupName, profileName, endpointName, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EndpointInner stop(String resourceGroupName, String profileName, String endpointName) {
        return (EndpointInner)((Object)this.stopAsync(resourceGroupName, profileName, endpointName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EndpointInner stop(String resourceGroupName, String profileName, String endpointName, Context context) {
        return (EndpointInner)((Object)this.stopAsync(resourceGroupName, profileName, endpointName, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> purgeContentWithResponseAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (contentPaths == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentPaths is required and cannot be null."));
        }
        String accept = "application/json";
        PurgeParameters contentFilePaths = new PurgeParameters();
        contentFilePaths.withContentPaths(contentPaths);
        return FluxUtil.withContext(context -> this.service.purgeContent(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), contentFilePaths, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> purgeContentWithResponseAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (contentPaths == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentPaths is required and cannot be null."));
        }
        String accept = "application/json";
        PurgeParameters contentFilePaths = new PurgeParameters();
        contentFilePaths.withContentPaths(contentPaths);
        context = this.client.mergeContext(context);
        return this.service.purgeContent(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), contentFilePaths, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginPurgeContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.purgeContentWithResponseAsync(resourceGroupName, profileName, endpointName, contentPaths);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginPurgeContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.purgeContentWithResponseAsync(resourceGroupName, profileName, endpointName, contentPaths, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginPurgeContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return this.beginPurgeContentAsync(resourceGroupName, profileName, endpointName, contentPaths).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginPurgeContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        return this.beginPurgeContentAsync(resourceGroupName, profileName, endpointName, contentPaths, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return this.beginPurgeContentAsync(resourceGroupName, profileName, endpointName, contentPaths).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> purgeContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        return this.beginPurgeContentAsync(resourceGroupName, profileName, endpointName, contentPaths, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        this.purgeContentAsync(resourceGroupName, profileName, endpointName, contentPaths).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        this.purgeContentAsync(resourceGroupName, profileName, endpointName, contentPaths, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> loadContentWithResponseAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (contentPaths == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentPaths is required and cannot be null."));
        }
        String accept = "application/json";
        LoadParameters contentFilePaths = new LoadParameters();
        contentFilePaths.withContentPaths(contentPaths);
        return FluxUtil.withContext(context -> this.service.loadContent(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), contentFilePaths, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> loadContentWithResponseAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (contentPaths == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentPaths is required and cannot be null."));
        }
        String accept = "application/json";
        LoadParameters contentFilePaths = new LoadParameters();
        contentFilePaths.withContentPaths(contentPaths);
        context = this.client.mergeContext(context);
        return this.service.loadContent(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), contentFilePaths, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginLoadContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.loadContentWithResponseAsync(resourceGroupName, profileName, endpointName, contentPaths);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginLoadContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.loadContentWithResponseAsync(resourceGroupName, profileName, endpointName, contentPaths, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginLoadContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return this.beginLoadContentAsync(resourceGroupName, profileName, endpointName, contentPaths).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginLoadContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        return this.beginLoadContentAsync(resourceGroupName, profileName, endpointName, contentPaths, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> loadContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return this.beginLoadContentAsync(resourceGroupName, profileName, endpointName, contentPaths).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> loadContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        return this.beginLoadContentAsync(resourceGroupName, profileName, endpointName, contentPaths, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void loadContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        this.loadContentAsync(resourceGroupName, profileName, endpointName, contentPaths).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void loadContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        this.loadContentAsync(resourceGroupName, profileName, endpointName, contentPaths, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ValidateCustomDomainOutputInner>> validateCustomDomainWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String hostname) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (hostname == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostname is required and cannot be null."));
        }
        String accept = "application/json";
        ValidateCustomDomainInput customDomainProperties = new ValidateCustomDomainInput();
        customDomainProperties.withHostname(hostname);
        return FluxUtil.withContext(context -> this.service.validateCustomDomain(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), customDomainProperties, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ValidateCustomDomainOutputInner>> validateCustomDomainWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String hostname, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (hostname == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostname is required and cannot be null."));
        }
        String accept = "application/json";
        ValidateCustomDomainInput customDomainProperties = new ValidateCustomDomainInput();
        customDomainProperties.withHostname(hostname);
        context = this.client.mergeContext(context);
        return this.service.validateCustomDomain(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), customDomainProperties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ValidateCustomDomainOutputInner> validateCustomDomainAsync(String resourceGroupName, String profileName, String endpointName, String hostname) {
        return this.validateCustomDomainWithResponseAsync(resourceGroupName, profileName, endpointName, hostname).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ValidateCustomDomainOutputInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ValidateCustomDomainOutputInner validateCustomDomain(String resourceGroupName, String profileName, String endpointName, String hostname) {
        return (ValidateCustomDomainOutputInner)this.validateCustomDomainAsync(resourceGroupName, profileName, endpointName, hostname).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ValidateCustomDomainOutputInner> validateCustomDomainWithResponse(String resourceGroupName, String profileName, String endpointName, String hostname, Context context) {
        return (Response)this.validateCustomDomainWithResponseAsync(resourceGroupName, profileName, endpointName, hostname, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceUsageInner>> listResourceUsageSinglePageAsync(String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listResourceUsage(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceUsageListResult)res.getValue()).value(), ((ResourceUsageListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceUsageInner>> listResourceUsageSinglePageAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listResourceUsage(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceUsageListResult)res.getValue()).value(), ((ResourceUsageListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ResourceUsageInner> listResourceUsageAsync(String resourceGroupName, String profileName, String endpointName) {
        return new PagedFlux(() -> this.listResourceUsageSinglePageAsync(resourceGroupName, profileName, endpointName), nextLink -> this.listResourceUsageNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ResourceUsageInner> listResourceUsageAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        return new PagedFlux(() -> this.listResourceUsageSinglePageAsync(resourceGroupName, profileName, endpointName, context), nextLink -> this.listResourceUsageNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceUsageInner> listResourceUsage(String resourceGroupName, String profileName, String endpointName) {
        return new PagedIterable(this.listResourceUsageAsync(resourceGroupName, profileName, endpointName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceUsageInner> listResourceUsage(String resourceGroupName, String profileName, String endpointName, Context context) {
        return new PagedIterable(this.listResourceUsageAsync(resourceGroupName, profileName, endpointName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EndpointInner>> listByProfileNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProfileNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EndpointListResult)res.getValue()).value(), ((EndpointListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EndpointInner>> listByProfileNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByProfileNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EndpointListResult)res.getValue()).value(), ((EndpointListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceUsageInner>> listResourceUsageNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listResourceUsageNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceUsageListResult)res.getValue()).value(), ((ResourceUsageListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceUsageInner>> listResourceUsageNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listResourceUsageNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceUsageListResult)res.getValue()).value(), ((ResourceUsageListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClientE")
    private static interface EndpointsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EndpointListResult>> listByProfile(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EndpointInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") EndpointInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") EndpointUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> start(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/stop")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> stop(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/purge")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> purgeContent(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") PurgeParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/load")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> loadContent(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") LoadParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/validateCustomDomain")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ValidateCustomDomainOutputInner>> validateCustomDomain(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ValidateCustomDomainInput var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/checkResourceUsage")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceUsageListResult>> listResourceUsage(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EndpointListResult>> listByProfileNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceUsageListResult>> listResourceUsageNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

