/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.models.ResourceNamespacePatch;
import com.azure.resourcemanager.servicebus.models.SBSku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

@JsonFlatten
public class SBNamespaceUpdateParameters
extends ResourceNamespacePatch {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SBNamespaceUpdateParameters.class);
    @JsonProperty(value="sku")
    private SBSku sku;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.createdAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdAt;
    @JsonProperty(value="properties.updatedAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime updatedAt;
    @JsonProperty(value="properties.serviceBusEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String serviceBusEndpoint;
    @JsonProperty(value="properties.metricId", access=JsonProperty.Access.WRITE_ONLY)
    private String metricId;

    public SBSku sku() {
        return this.sku;
    }

    public SBNamespaceUpdateParameters withSku(SBSku sku) {
        this.sku = sku;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public String serviceBusEndpoint() {
        return this.serviceBusEndpoint;
    }

    public String metricId() {
        return this.metricId;
    }

    @Override
    public SBNamespaceUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public SBNamespaceUpdateParameters withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

