/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.implementation.DurationSerializer;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.MessageCountDetails;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Duration;
import java.time.OffsetDateTime;

@JsonFlatten
public class SBTopicInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SBTopicInner.class);
    @JsonProperty(value="properties.sizeInBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long sizeInBytes;
    @JsonProperty(value="properties.createdAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdAt;
    @JsonProperty(value="properties.updatedAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime updatedAt;
    @JsonProperty(value="properties.accessedAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime accessedAt;
    @JsonProperty(value="properties.subscriptionCount", access=JsonProperty.Access.WRITE_ONLY)
    private Integer subscriptionCount;
    @JsonProperty(value="properties.countDetails", access=JsonProperty.Access.WRITE_ONLY)
    private MessageCountDetails countDetails;
    @JsonProperty(value="properties.defaultMessageTimeToLive")
    @JsonSerialize(using=DurationSerializer.class)
    private Duration defaultMessageTimeToLive;
    @JsonProperty(value="properties.maxSizeInMegabytes")
    private Integer maxSizeInMegabytes;
    @JsonProperty(value="properties.requiresDuplicateDetection")
    private Boolean requiresDuplicateDetection;
    @JsonProperty(value="properties.duplicateDetectionHistoryTimeWindow")
    @JsonSerialize(using=DurationSerializer.class)
    private Duration duplicateDetectionHistoryTimeWindow;
    @JsonProperty(value="properties.enableBatchedOperations")
    private Boolean enableBatchedOperations;
    @JsonProperty(value="properties.status")
    private EntityStatus status;
    @JsonProperty(value="properties.supportOrdering")
    private Boolean supportOrdering;
    @JsonProperty(value="properties.autoDeleteOnIdle")
    @JsonSerialize(using=DurationSerializer.class)
    private Duration autoDeleteOnIdle;
    @JsonProperty(value="properties.enablePartitioning")
    private Boolean enablePartitioning;
    @JsonProperty(value="properties.enableExpress")
    private Boolean enableExpress;

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public OffsetDateTime accessedAt() {
        return this.accessedAt;
    }

    public Integer subscriptionCount() {
        return this.subscriptionCount;
    }

    public MessageCountDetails countDetails() {
        return this.countDetails;
    }

    public Duration defaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public SBTopicInner withDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public Integer maxSizeInMegabytes() {
        return this.maxSizeInMegabytes;
    }

    public SBTopicInner withMaxSizeInMegabytes(Integer maxSizeInMegabytes) {
        this.maxSizeInMegabytes = maxSizeInMegabytes;
        return this;
    }

    public Boolean requiresDuplicateDetection() {
        return this.requiresDuplicateDetection;
    }

    public SBTopicInner withRequiresDuplicateDetection(Boolean requiresDuplicateDetection) {
        this.requiresDuplicateDetection = requiresDuplicateDetection;
        return this;
    }

    public Duration duplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    public SBTopicInner withDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    public Boolean enableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public SBTopicInner withEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public EntityStatus status() {
        return this.status;
    }

    public SBTopicInner withStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public Boolean supportOrdering() {
        return this.supportOrdering;
    }

    public SBTopicInner withSupportOrdering(Boolean supportOrdering) {
        this.supportOrdering = supportOrdering;
        return this;
    }

    public Duration autoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public SBTopicInner withAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public Boolean enablePartitioning() {
        return this.enablePartitioning;
    }

    public SBTopicInner withEnablePartitioning(Boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
        return this;
    }

    public Boolean enableExpress() {
        return this.enableExpress;
    }

    public SBTopicInner withEnableExpress(Boolean enableExpress) {
        this.enableExpress = enableExpress;
        return this;
    }

    public void validate() {
        if (this.countDetails() != null) {
            this.countDetails().validate();
        }
    }
}

